gan-ait-support
===============

Programs and some data files used for work on ab-initio thermodynamics of GaN oxidation.
Supporting information for [Jackson, A. J. & Walsh, A. Oxidation of GaN: An ab initio thermodynamic approach. *Phys. Rev. B* **88**, 165201 (2013)](http://dx.doi.org/10.1103/PhysRevB.88.165201); figure numbers refer to this paper.

Note that these programs are not especially efficient and prioritise clarity and maintainability over speed.

Files
-----

### Data
* `data/(material)/control.in`: Control.in file used for phonopy-FHI-aims calculation
* `data/(material)/phonopy-FHI-aims-free_energy.dat`: thermal properties from phonopy-FHI-aims
* `gas_zpe.m`: Unit conversions of literature data for gas zero-point energy

### Functions
* `A_IntCp.m`: Analytically-integrated heat capacities for gases from Shomate equations.
* `E_solid.m`: Ground state energies of solids from all-electron DFT calculations with PBEsol functional.
* `gibbs_examples.m`: Print table of contributions to oxidation free energy at given temperatures.
* `H_(material).m`: Functions returning material enthalpies for given (T,P)
* `mu_(material).m`: Chemical potential of material for given (T,P)
checking
* `Sig.m`: Entropy of ideal gas from Shomate equations
* `phonon_results_interp.py`: Interpolates free energy at 298.15K from given data file. Slow - used for sanity
* `phonon_results_table.m`: Generates a (mostly) LaTeX-ready data table from phonon data

### Plots

* `(material)_Cp_lit.m`: Plot heat capacity from Phonopy calculations vs literature data (Figs. 8-9)
* `conc_dependence_G.m`: Plot free energy of oxidation for two supercells with correction. (Not in paper, similar to Fig. 15.)
* `conc_dependence_H.m`: Plot concentration dependence of oxidation enthalpy (Fig. 15)
* `enthalpies.m`: Calculate formation enthalpies of GaN and Ga2O3, plotting contributions of potential and vibration terms (Figs. 11-12)
* `full_oxidation.m`: Gibbs free energy of complete oxidation over selection of partial pressure ratios and T range (Fig. 13)
* `full_oxidation_colours.m`: Coloured free energy plot over continuous partial pressure range, many T lines. (Not in paper.)
* `full_oxidation_p.m`: Full oxidation free energy vs log(P) (Fig. 14)
* `normalised_Cp.m`: Solid-state heat capacities plot in kB/atom (Fig. 7) and heat capacity difference from defect formation (similar to Fig. 10)
* `normalised_S.m`: Entropy values from phonon calculations (Fig. 6)
* `phonon_curves.m`: Phonon band structures (Figs. 2-5)
* `G_contours.m`: Plot Gibbs free energy surface of oxygen defect formation (Figs. 17-18)
* `S_72_sub.m`: Plot Gibbs free energy of partial oxidation of 72-atom supercell over range of T,P. (Fig. 16)
* `sub_128.m`, `sub_300.m`: Gibbs free energy of partial oxidation in larger (128 and 300-atom) supercells. (Not in paper, similar to Fig. 16.)
