%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%         sub_300.m: Script to plot free energy change of a substitutional     %
%                   oxygen defect in GaN over a range of temperatures and      %
%                   pressures.                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [100:100:2000]; % set up T range

log10P = [3:2:10]'; % set up logarithmic P range
pO2 = 10.^log10P;
pN2 = 10.^log10P(end:-1:1);

P = pN2 + pO2; % Sum partial pressures (ideal behaviour)

Gibbs = mu_supercell('S_300',T,P) + 0.5*mu_N2(T,pN2) ...
        	- 150*mu_solid('GaN',T,P) - 0.5*mu_O2(T,pO2);

plot(T,Gibbs'/1E3,'k');

xlabel('T / K','interpreter','latex');
ylabel('$\Delta G / $kJ mol$^{-1}$','interpreter','latex');

titlestring = sprintf('Oxidation of GaN to Ga$_{150}$N$_{149}$O');
title(titlestring,'interpreter','latex');

for i = 1:length(log10P)
line_label = sprintf('$[p_{\\text{N}_2} p_{\\text{O}_2}],  = [%1.0E , %1.0E]$', ...
		     pN2(i)/1E3, pO2(i)/1E3);
text(1400,Gibbs(i,end-6)/1E3,line_label,'interpreter','latex');

end