function [R] = ReflectVector(V, N)
% Dr Jody Muelaner 2015, University of Bath, jody@muelaner.com
% Reflects a 3D vector about a surface normal vector
% [R] = ReflectVector(V, N)
%
% OUTPUTS:
% * R  = Reflected column vector (same magnitude as V)
%
% INPUTS:
% * V = The incoming vector (3D column vector)
% * N = The surface normal vector (3D column vector pointing out of surface)
% * Note: N does not need to be normalized, the function will do this

N = N/norm(N); % Normalize N
dotproduct = dot(V,N); % Find dot product
R = 2*dotproduct*N-V; % Find reflected vector
end