%function [Final] = MISTalign05(inputs)
% Simulates alignment of AMS interferometer
% V6 replaces MISTalign05
%r_det = inputs(1);
%Ip = inputs(2);
%dIx = inputs(3);
%dIz = inputs(4);
%dIrx = inputs(5);
%dIrz = inputs(6);
%% Take inputs for simulated alignment:
r = 50;
% Moved to function:
r_det = 0.2; Ip = 0.05; % Configure interferometer
dIx = 1; dIz = 1; dIrx = -0.1; dIrz = -0.1; % Initial errors for simulation (unknown)

%% Set 3 parameters for the alignment process:
rangexz = 4; % Range to scan over (mm) 4 = +/-2mm
nP = 8; % number of steps in intial scans (max P)
nE = 200; % number of steps in intial scans (min E) 
Ptol = 0.00001; % Min ratio between values to exit search for max power
stepR = 0.01; % Initial increment in angle to find rOverX
Etol = 0.005; % Min ratio between values to exit search for min path error

%% Find max power position for dIx ( dIxMaxP1 )
% Scan over initial range of dIx values:
dIxMin = dIx-rangexz/2; dIxMax = dIx+rangexz/2;
step = (dIxMax-dIxMin)/(nP-1); Pmax = 0;
for dIx = dIxMin:step:dIxMax; % Start the scan
    [~,~,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    if P>Pmax
        Pmax = P; dIxMaxP = dIx;
    end
    YesNo=exist('Results','var'); % Check if we have any results yet
    if YesNo == 0
        Results = [dIx, dIz, dIrx, dIrz, NaN, NaN, P]; % Store the results
    else
        Results = [Results;dIx, dIz, dIrx, dIrz, NaN, NaN, P]; % Store the results
    end
end
dIx = dIxMaxP; % Move dIx to max P position
outStr=strcat({'Completed 1st scan in dIx'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find max power
    step = step/2; % Reduce step size on each iteration
    % Calculate power at detector and store results for all iterations
    [~,~,P(1)] = amsSim(r, r_det, Ip, dIx-step, dIz, dIrx, dIrz);
    Results = [Results;dIx-step, dIz, dIrx, dIrz, NaN, NaN, P(1)]; % Store the results
    [~,~,P(2)] = amsSim(r, r_det, Ip, dIx+step, dIz, dIrx, dIrz);
    Results = [Results;dIx+step, dIz, dIrx, dIrz, NaN, NaN, P(2)]; % Store the results
    % Find max power and re-centre the search on it
    if P(1)>Pmax
        Pmax=P(1); dIx = dIx-step;
    end
    if P(2)>Pmax
        Pmax=P(2);  dIx = dIx+step;
    end
    if range(P)/mean(P)<Ptol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed 1st search in dIx interation '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end
dIxMaxP1 = dIx;
outStr=strcat({'Completed 1st search in dIx (ALL INTERATIONS)'}); disp(outStr);

%% Increment dIrz and find max power position for dIx ( dIxMaxP2 )
dIrz = dIrz + stepR;
% Scan over initial range of dIx values:
dIxMin = dIx-rangexz/2; dIxMax = dIx+rangexz/2;
step = (dIxMax-dIxMin)/(nP-1); Pmax = 0;
for dIx = dIxMin:step:dIxMax; % Start the scan
    [~,~,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    Results = [Results;dIx, dIz, dIrx, dIrz, NaN, NaN, P]; % Store the results
    if P>Pmax
        Pmax = P; dIxMaxP = dIx;
    end
end
dIx = dIxMaxP; % Move dIx to max P position
outStr=strcat({'Completed 2nd scan in dIx'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find max power
    step = step/2; % Reduce step size on each iteration
    % Calculate power at detector and store results for all iterations
    [~,~,P(1)] = amsSim(r, r_det, Ip, dIx-step, dIz, dIrx, dIrz);
    Results = [Results;dIx-step, dIz, dIrx, dIrz, NaN, NaN, P(1)]; % Store the results
    [~,~,P(2)] = amsSim(r, r_det, Ip, dIx+step, dIz, dIrx, dIrz);
    Results = [Results;dIx+step, dIz, dIrx, dIrz, NaN, NaN, P(2)]; % Store the results
    % Find max power and re-centre the search on it
    if P(1)>Pmax
        Pmax=P(1); dIx = dIx-step;
    end
    if P(2)>Pmax
        Pmax=P(2);  dIx = dIx+step;
    end
    if range(P)/mean(P)<Ptol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed 2nd search in dIx interation '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end
dIxMaxP2 = dIx;
outStr=strcat({'Completed 2nd search in dIx (ALL INTERATIONS)'}); disp(outStr);

%% Calculate ratio of steps in dIrz/dIx for constant power & find min path
rOverX = stepR / (dIxMaxP2 - dIxMaxP1); % Find ratio angle/translation
% Scan over initial range of dIx & dIrz values:
dIxMin = dIx-rangexz/2; dIxMax = dIx+rangexz/2;
dIrz = dIrz - (dIx - dIxMin)*rOverX; % Set dIrz to start matching dIx
step = (dIxMax-dIxMin)/(nE-1); % Set step size for dIx
dIrzStep = step * rOverX; % Set step size for dIrz
Emin = 1000; % Set initial large value for min path error
for dIx = dIxMin:step:dIxMax; % Scan over dIx & dIrz together
    [E,R,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    Results = [Results;dIx, dIz, dIrx, dIrz, E, R, P]; % Store the results
    if E<Emin
        Emin = E; dIxMinE = dIx; dIrzMinE = dIrz;
    end
    if dIx<dIxMax % for all iterations except last one
        dIrz = dIrz + dIrzStep; % Increment dIrz with dIx
    end
    % Check if there is a signal
    YesNo=exist('signal','var'); % Check if we have any results yet
    if YesNo == 0
        if R<0.7
            signal = 1; % Record first detected signal
        end
    else
        if R<0.7
            signal = signal+1; % Record another detected signal
        end
    end
end
% If we don't have 3 positions with detectable fringes
if exist('signal','var')==0 || signal<3 
    %Function returns nan and stops
    Final = [NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN];
    disp('Alignment failed (not enough fringes seen scanning dIx & dIrz)');
    return
end
clear signal; % Clear signal count for next DoF
dIx = dIxMinE; dIrz = dIrzMinE; % Move dIx & dIrz to min error position
outStr=strcat({'Completed scan in dIx & dIrz for Min path error'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find min error
    step = step/2; dIrzStep=dIrzStep/2; % Half step size each iteration
    [E(1),R,P] = amsSim(r, r_det, Ip, dIx-step, dIz, dIrx, dIrz-dIrzStep);
    Results = [Results;dIx-step, dIz, dIrx, dIrz-dIrzStep, E(1), R, P]; % Store the results
    [E(2),~,~] = amsSim(r, r_det, Ip, dIx+step, dIz, dIrx, dIrz+dIrzStep);
    Results = [Results;dIx+step, dIz, dIrx, dIrz+dIrzStep, E(2), R, P]; % Store the results
    if E(1)<Emin
        Emin=E(1); dIx=dIx-step; dIrz=dIrz-dIrzStep; % Move to current values
    end
    if E(2)<Emin
        Emin=E(2);  dIx = dIx+step; dIrz=dIrz+dIrzStep; % Move to current values
    end
    if range(E)/mean(E)<Etol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed search in dIx & dIrz for Min path error, interation: '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end

outStr=strcat({'Completed search in dIx for Min path error (ALL INTERATIONS)'}); disp(outStr);

%% THIS IS WHERE I BREAK FIRST 2 DoF AND COPY DoF 3 & 4....

%% Find max power position for dIz ( dIzMaxP1 )
% Scan over initial range of dIz values:
dIzMin = dIz-rangexz/2; dIzMax = dIz+rangexz/2;
step = (dIzMax-dIzMin)/(nP-1); Pmax = 0;
for dIz = dIzMin:step:dIzMax; % Start the scan
    [~,~,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    if P>Pmax
        Pmax = P; dIzMaxP = dIz;
    end
    Results = [Results;dIx, dIz, dIrx, dIrz, NaN, NaN, P]; % Store the results
end
dIz = dIzMaxP; % Move dIz to max P position
outStr=strcat({'Completed 1st scan in dIz'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find max power
    step = step/2; % Reduce step size on each iteration
    % Calculate power at detector and store results for all iterations
    [~,~,P(1)] = amsSim(r, r_det, Ip, dIx, dIz-step, dIrx, dIrz);
    Results = [Results;dIx, dIz-step, dIrx, dIrz, NaN, NaN, P(1)]; % Store the results
    [~,~,P(2)] = amsSim(r, r_det, Ip, dIx, dIz+step, dIrx, dIrz);
    Results = [Results;dIx, dIz+step, dIrx, dIrz, NaN, NaN, P(2)]; % Store the results
    % Find max power and re-centre the search on it
    if P(1)>Pmax
        Pmax=P(1); dIz = dIz-step;
    end
    if P(2)>Pmax
        Pmax=P(2);  dIz = dIz+step;
    end
    if range(P)/mean(P)<Ptol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed 1st search in dIz interation '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end
dIzMaxP1 = dIz;
outStr=strcat({'Completed 1st search in dIz (ALL INTERATIONS)'}); disp(outStr);

%% Increment dIrx and find max power position for dIz ( dIzMaxP2 )
dIrx = dIrx + stepR;
% Scan over initial range of dIz values:
dIzMin = dIz-rangexz/2; dIzMax = dIz+rangexz/2;
step = (dIzMax-dIzMin)/(nP-1); Pmax = 0;
for dIz = dIzMin:step:dIzMax; % Start the scan
    [~,~,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    Results = [Results;dIx, dIz, dIrx, dIrz, NaN, NaN, P]; % Store the results
    if P>Pmax
        Pmax = P; dIzMaxP = dIz;
    end
end
dIz = dIzMaxP; % Move dIz to max P position
outStr=strcat({'Completed 2nd scan in dIz'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find max power
    step = step/2; % Reduce step size on each iteration
    % Calculate power at detector and store results for all iterations
    [~,~,P(1)] = amsSim(r, r_det, Ip, dIx, dIz-step, dIrx, dIrz);
    Results = [Results;dIx, dIz-step, dIrx, dIrz, NaN, NaN, P(1)]; % Store the results
    [~,~,P(2)] = amsSim(r, r_det, Ip, dIx, dIz+step, dIrx, dIrz);
    Results = [Results;dIx, dIz+step, dIrx, dIrz, NaN, NaN, P(2)]; % Store the results
    % Find max power and re-centre the search on it
    if P(1)>Pmax
        Pmax=P(1); dIz = dIz-step;
    end
    if P(2)>Pmax
        Pmax=P(2);  dIz = dIz+step;
    end
    if range(P)/mean(P)<Ptol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed 2nd search in dIz interation '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end
dIzMaxP2 = dIz;
outStr=strcat({'Completed 2nd search in dIz (ALL INTERATIONS)'}); disp(outStr);

%% Calculate ratio of steps in dIrx/dIz for constant power & find min path
rOverX = stepR / (dIzMaxP2 - dIzMaxP1); % Find ratio angle/translation
% Scan over initial range of dIz & dIrx values:
dIzMin = dIz-rangexz/2; dIzMax = dIz+rangexz/2;
dIrx = dIrx - (dIz - dIzMin)*rOverX; % Set dIrx to start matching dIz
step = (dIzMax-dIzMin)/(nE-1); % Set step size for dIz
dIrxStep = step * rOverX; % Set step size for dIrx
Emin = 1000; % Set initial large value for min path error
for dIz = dIzMin:step:dIzMax; % Scan over dIz & dIrx together
    % dIrz = dIrz * rOverX; This isn't right, I need to get this right!
    % And then continue writting this section...
    [E,R,P] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    Results = [Results;dIx, dIz, dIrx, dIrz, E, R, P]; % Store the results
    if E<Emin
        Emin = E; dIzMinE = dIz; dIrxMinE = dIrx;
    end
    if dIz<dIzMax % for all iterations except last one
        dIrx = dIrx + dIrxStep; % Increment dIrx with dIz
    end
        % Check if there is a signal
    YesNo=exist('signal','var'); % Check if we have any results yet
    if YesNo == 0
        if R<0.7
            signal = 1; % Record first detected signal
        end
    else
        if R<0.7
            signal = signal+1; % Record another detected signal
        end
    end
end
% If we don't have 3 positions with detectable fringes
if exist('signal','var')==0 || signal<3 
    %Function returns nan and stops
    Final = [NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN];
    disp('Alignment failed (not enough fringes seen scanning dIz & dIrx)');
    return
end
dIz = dIzMinE; dIrx = dIrxMinE; % Move dIz & dIrx to min error position
outStr=strcat({'Completed scan in dIz & dIrx for Min path error'}); disp(outStr);
loop = 1; counter = 1; % Set loop flag and count
while loop == 1 % start binary search to find min error
    step = step/2; dIrxStep=dIrxStep/2; % Half step size each iteration
    [E(1),R,P] = amsSim(r, r_det, Ip, dIx, dIz-step, dIrx-dIrxStep, dIrz);
    Results = [Results;dIx, dIz-step, dIrx-dIrxStep, dIrz, E(1), R, P]; % Store the results
    [E(2),~,~] = amsSim(r, r_det, Ip, dIx, dIz+step, dIrx+dIrxStep, dIrz);
    Results = [Results;dIx, dIz+step, dIrx+dIrxStep, dIrz, E(2), R, P]; % Store the results
    if E(1)<Emin
        Emin=E(1); dIz=dIz-step; dIrx=dIrx-dIrxStep; % Move to current values
    end
    if E(2)<Emin
        Emin=E(2);  dIz = dIz+step; dIrx=dIrx+dIrxStep; % Move to current values
    end
    if range(E)/mean(E)<Etol % Check if search has converged
        loop=0;
    end
    outStr=strcat({'Completed search in dIz & dIrx for Min path error, interation: '}, num2str(counter)); disp(outStr);
    counter = counter + 1; % Increment the counter
end

outStr=strcat({'Completed ALL SEARCHES - IFM ALIGNED'}); disp(outStr);

iterations = size(Results); iterations=iterations(1,1);
Final = [Results(iterations,:), iterations];
%end
