function [ErrorMag, Pfail, Rfail] = amsAlignTol(r, r_det, Ip)
% Was MISTerrorLimit
% Given an initial IFM parameter set it finds limiting alignment so
% that:
Pmin = 1; % Minimum Throughput (10^-9)
Ptol = Pmin/50; % Tolerance to find Pmin
RangeEmax = 0.4; % Max range in path errors for fringe (microns)
RangeEtol = RangeEmax/50; % Tolerance to find RangeEtol

dIx = 0; dIrz = 0; % Consider case where one DoF has been aligned
    % Remember that after search in dIx power is same and then stepping
    % dIx and dIrz together power is constant and we find min RangeE
dIz = 0; % Start at zero error
dIzStep = 0.1; % Set step size for translation error
loop = 1; Pfail=0; Rfail=0; % Set loop flag & markers
%Results=[0, 0]; % Create variable to store convergence results

while loop == 1 % Loop stepping error magnidue to locate failure point
    dIz = dIz + dIzStep; % Step through alignment errors
    dIrx = dIz * -0.111; % Set angle to be worst case equivelent to dIz
    [~,RangeE,TotalP] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
    %Results = [Results;RangeE, TotalP]; % Store results
    if TotalP < Pmin
        loop=0; Pfail=1; % Exit loop & record failure condition
    end
    if RangeE > RangeEmax
        loop=0; Rfail=1; % Exit loop & record failure condition
    end
end

if Pfail==1
    % Then search by power
    while abs(TotalP-Pmin)>Ptol
        dIzStep = dIzStep/2; % Set size and direction for step
        dIz = dIz + sign(TotalP-Pmin)*dIzStep; % Step through alignment errors
        dIrx = dIz * -0.111; % Set angle to be worst case equivelent to dIz
        [~,~,TotalP] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
        %Results = [Results;RangeE, TotalP]; % Store results        
    end
else
    % Search by range
    while abs(RangeEmax-RangeE)>RangeEtol
        dIzStep = dIzStep/2; % Set size and direction for step
        dIz = dIz + sign(RangeEmax-RangeE)*dIzStep; % Step through alignment errors
        dIrx = dIz * -0.111; % Set angle to be worst case equivelent to dIz
        [~,RangeE,~] = amsSim(r, r_det, Ip, dIx, dIz, dIrx, dIrz);
        %Results = [Results;RangeE, TotalP]; % Store results 
    end
end
    % outStr=strcat({'***ERROR LIMITS FOUND: Magnitude '},num2str(dIz),{' mm'});
    % disp(outStr);
ErrorMag = dIz;
end
% Then I will use that function to loop through different parameter sets to optimize!
