% Finds maximum starting errors for auto alignment 

close all; clear; clc;

% Generate a full factorial set of input parameters
r = 50;
rDet = [0.01 0.02 0.03 0.04 0.07 0.1 0.15 0.2 0.3 0.4 0.5 0.6 0.7];
Ip = [0.05 0.1 0.3 0.5 0.7 0.9 0.95];

%Generate factor settings (full factorial)
facScalers = fullfact([length(r) length(rDet) length(Ip)]); %
inputs(:,1) = r(facScalers(:,1));
inputs(:,2) = rDet(facScalers(:,2));
inputs(:,3) = Ip(facScalers(:,3));

%% Start the simulations

% Set limits for initial perfect alignment check
Pmin = 1; % Minimum Throughput (10^-9)
RangeEmax = 0.4; % Max range in path errors for fringe (microns)

n = size(inputs); n = n(1); % Number of starting cases entred
Results = zeros(n,4);

for i = 1:n
    tic;
    r=inputs(i,1); r_det=inputs(i,2); Ip=inputs(i,3);
    % Check if there is a signal when perfectly aligned!
    [~,RangeE,TotalP] = amsSim(r, r_det, Ip, 0, 0, 0, 0);
    if RangeE>RangeEmax || TotalP<Pmin % If no signal is possible
        if RangeE>RangeEmax
            Rfail=1;
        else
            Rfail=0;
        end
        if TotalP<Pmin
            Pfail=1;
        else
            Pfail=0;
        end
        Results(i,:)=[0, Pfail, Rfail, 0];
        outStr=strcat({'NO SIGNAL POSSIBLE for case '},num2str(i),{' of '},num2str(n));
        disp(outStr);
    else % Check the error limits
        [ErrorMag, Pfail, Rfail] = amsAlignTol(r, r_det, Ip);
        Timer = toc/60; % Time in minutes
        Results(i,:)=[ErrorMag, Pfail, Rfail, 1];
        outStr=strcat({'IFM ALIGNED for case '},num2str(i),{' of '},num2str(n),{' in '},num2str(Timer),{' minutes.'});
        disp(outStr);
        outStr=strcat({'Error Magnitude = '},num2str(ErrorMag),{' mm'});
        disp(outStr);
    end
end

outStr=strcat('ALL PARAMETER SETS SIMULATED');
disp(outStr);