function [NetworkUncert20m, NetworkUncert4m, time] = amsNetwork2D(L, W, uScale, uRandom, n)

% Simulates propagation of uncertainty in simple 2D determinate truss
%clc; close all; clear; % Clear ready to start
tic;

% Input geometry of network
%L = 20; % Length in m
%W = 1; % width of network (=scale bar length) in m
nL = L/W;
% Input the network uncertainty
%uScale = 0.5; % m/m scale error uncertainty across network (0.5)
%uRandom = 4; % m random uncertainties in each scale bar (4)
% Input number of Monte Carlo iterations
%n = 3000;

% Convert geometry to mm and define nominal coordinates
L = L*1000; W = W*1000; % Dimensions in mm
uScale = uScale*10^-6; % Scale uncertainty in mm/mm
uRandom = uRandom*10^-3; % Random uncertainty in mm
A = 0:W:L; A = A';
A0 = zeros(length(A),1);
Anom = [A A0];
B = A0+W;
Bnom = [A(:,1) B];
Ld = sqrt(2*W^2); % Length of diagonal

%% Run MCS

Error20m = zeros(n,2); % Empty array to store results
Error4m = zeros(n,2); % Empty array to store results

for i=1:n % Loop through Monte Carlo iterations
    eScale = uScale*randn; % Simulate scale error
    
    % Simulate lengths
    LA = ones(nL,1); LA = LA*W*(1+eScale) + uRandom*randn(nL,1); % 
    LB = ones(nL,1); LB = LB*W*(1+eScale) + uRandom*randn(nL,1); % Nominal lengths LB
    LAB = ones(nL+1,1); LAB = LAB*W*(1+eScale) + uRandom*randn(nL+1,1); % Nominal lengths LB
    LdAll = ones(nL,1); LdAll = LdAll*Ld*(1+eScale) + uRandom*randn(nL,1); % Nominal lengths LB
    
    % Find coordinates
    A = [0 0]; B = [0, LAB(1)]; % Set base coordinate system
    
    for k = 1:2:nL-1 % Loop through generating coordinates for alternating truss
    
    At = intersectCircles([A(k,:), LA(k)], [B(k,:), LdAll(k)]); % Find poss coords
    [~, I] = max(At); % Find row in right direction
    A(k+1,:) = At(I(1),:); % Select correct coordinate
    
    Bt = intersectCircles([B(k,:), LB(k)], [A(k+1,:), LAB(k+1)]); % Find poss coords
    [~, I] = max(Bt); % Find row in right direction
    B(k+1,:) = Bt(I(1),:); % Select correct coordinate
    
    Bt = intersectCircles([B(k+1,:), LB(k+1)], [A(k+1,:), LdAll(k+1)]); % Find poss coords
    [~, I] = max(Bt); % Find row in right direction
    B(k+2,:) = Bt(I(1),:); % Select correct coordinate
    
    At = intersectCircles([A(k+1,:), LA(k+1)], [B(k+2,:), LAB(k+2)]); % Find poss coords
    [~, I] = max(At); % Find row in right direction
    A(k+2,:) = At(I(1),:); % Select correct coordinate
    %disp(num2str(k));
    
    end
    
    Error20m(i,:) = B(nL+1,:)-Bnom(nL+1,:);
    Error4m(i,:) = B(5,:)-Bnom(5,:);
    
    
end % End Monte Carlo loop

% Output the uncertainty at end of network:
NetworkUncert20m = std(Error20m);
NetworkUncert4m = std(Error4m);

time = toc;
end