%Solves AMS interferometer for multiple parameter sets
% V1: Based on MISTSensitivity06 but ref. new amsSim function
%Returns
% * MeanE & RangeE in microns, TotalP in microW

clear; close all; clc;
inputs=0;

%% Now enter inputs r, r_det, Ip, dIx,dIz,dIrx,dIrz

sizeIn = size(inputs); n = sizeIn(1);
outputs = zeros(n,3);

for i=1:n
    outStr=strcat({'starting simulation '},num2str(i),{' of '},num2str(n));
    disp(outStr)

    r = inputs(i,1); r_det = inputs(i,2); Ip = inputs(i,3);
    dIx = inputs(i,4); dIz = inputs(i,5); dIrx = inputs(i,6); dIrz = inputs(i,7);
    
    [meanE,RangeE,TotalP] = amsSim(r,r_det,Ip,dIx,dIz,dIrx,dIrz);
    outputs(i,:)=[meanE,RangeE,TotalP];
end

disp('COMPLETED ALL RUNS')