function [dist] = objFunC(limX, limZ, LAB, LCD, Ip, r, LEF, Beam,...
    ABry, ABrz, Brz, BrV1, Bn, dCx, dCz, dDx, dDz)
% Function takes current IFM parameters/alignment, initial ray position &
% target coordinates
% Function returns distance from target (objective to minimise)

BeamY = Beam(1); BeamZ = Beam(2); % Extract 2 values from 'Beam'

[~, ~, ~,~,~,C]  = amsRay(LAB, LCD, Ip, r, LEF, BeamY, BeamZ,...
    ABry, ABrz, Brz, BrV1, Bn, dCx, dCz, dDx, dDz); % Ray trace

if isnan(C)==1
    dist=1000; %dist = abs(1e12*BeamY*BeamZ);
else
distX = C(1)-limX; distZ = C(3)-limZ; % Find X & Z dist's from target
dist = sqrt(distX^2+distZ^2); % Find distance from target
end

end % end of function