function [dist] = objFunF(limY,limZ, LAB, LCD, Ip, r, LEF, Beam,...
    ABry, ABrz, Brz, BrV1, Bn, dCx, dCz, dDx, dDz)
% Function takes current IFM parameters/alignment, initial ray position &
% target coordinates
% Function returns distance from target (objective to minimise)

[~, ~, ~,~,~,~,~,~,F]  = amsRay(LAB, LCD, Ip, r, LEF, Beam(1), Beam(2),...
    ABry, ABrz, Brz, BrV1, Bn, dCx, dCz, dDx, dDz); % Ray trace

if isnan(F)==1
    dist=1000;
else
distY = F(2)-limY; distZ = F(3)-limZ; % Find Y & Z dist's from target
dist = sqrt(distY^2+distZ^2); % Find distance from target
end

end % end of function