% Plot the distributions of the IoU scores for the training and test sets
% figure 2a

load('iouEndTrain_a.mat')
load('iouEndTest_a.mat')

figure
histogram(iouEndTrain,'BinWidth',0.0125, 'FaceColor', 'c', 'LineWidth', 1,'Normalization','probability')
hold on
histogram(iouEndTest,'BinWidth',0.0125, 'FaceColor', 'r', 'LineWidth', 1,'Normalization','probability')
set(gca,'FontSize',20)
xlim([0,1])
xlabel('Jaccard index $J$', 'FontSize', 20, 'Interpreter', 'latex')
ylabel('Relative frequency', 'FontSize', 20)
legend({'Training', 'Test'}, 'Location','best')
legend BOXOFF

