% Plot the distributions of the IoU scores for the training and test sets,
% figure 2b
%
load('iouEndTrain_b.mat');
load('iouEndTest_b.mat');

figure;
histogram(iouEndTrain,'BinWidth',0.0125, 'FaceColor', 'c', 'LineWidth', 1,'Normalization','probability');
hold on;
histogram(iouEndTest,'BinWidth',0.0125, 'FaceColor', 'r', 'LineWidth', 1,'Normalization','probability');
set(gca,'FontSize',20);
ylim([0,0.15]);
xlabel('Jaccard index $J$', 'FontSize', 20, 'Interpreter', 'latex');
ylabel('Relative frequency', 'FontSize', 20);
legend({'Training', 'Test'}, 'Location','northwest');
legend BOXOFF;

