%%%%%%%%%%%%%%%%%%%
% Create ROC curve for figure 4
load('classTestResults.mat')

crosstab(table2array(classTestResults(:, 3)),table2array(classTestResults(:, 2)));

% no frac
[X0,Y0,T0,AUC00] = perfcurve(classTestResults.label==0,classTestResults.softmax(:,1),1); 
[X02,Y02,T02,AUC0] = perfcurve(classTestResults.label==0,classTestResults.softmax(:,1),1,'NBoot',1000,'XVals',[0:0.05:1]); 

% Inter
[X1,Y1,T1,AUC1] = perfcurve(classTestResults.label==1,classTestResults.softmax(:,2),1); 
[X12,Y12,T12,AUC1] = perfcurve(classTestResults.label==1,classTestResults.softmax(:,2),1,'NBoot',1000,'XVals',[0:0.05:1]); 

% Intra
[X2,Y2,T2,AUC2] = perfcurve(classTestResults.label==2,classTestResults.softmax(:,3),1); 
[X22,Y22,T22,AUC2] = perfcurve(classTestResults.label==2,classTestResults.softmax(:,3),1,'NBoot',1000,'XVals',[0:0.05:1]); 

%%%% plot
figure;
plot(X0,Y0,'Color', 'r', 'LineWidth',2);
%title('Receiver operating characteristic','fontsize',18)
xlabel('False Positive Rate','fontsize',18);
ylabel('True Positive Rate','fontsize',18);
xticks([0 0.2 0.4 0.6 0.8 1]);

hold on;
plot(X1,Y1,'Color', 'b', 'LineWidth',2, 'LineStyle','--');
plot(X2,Y2,'Color', 'm', 'LineWidth',2, 'LineStyle',':');
legend('No fracture (AUC=0.99)', 'Trochanteric (AUC=0.99)', 'Intracapsular (AUC=0.97)','Location','southeast');
set(gca,'FontSize',18);
hold off;
