%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%     G_contours.m: Script to plot free energy change of a substitutional      %
%                   oxygen defect in GaN over a range of temperatures and      %
%                   pressures.                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [100:100:2000]; % set up T range

log10P = [3:0.1:10]'; % set up logarithmic P range
pO2 = 1E3*ones(size(log10P));
pN2 = 10.^log10P;

P = pN2 + pO2; % Sum partial pressures (ideal behaviour)

Gibbs.('S_72') = mu_solid('S_72',T,P) + 0.5*mu_N2(T,pN2) ...
        	- 36*mu_solid('GaN',T,P) - 0.5*mu_O2(T,pO2);

Gibbs.('S_128') = mu_solid('S_128',T,P) + 0.5*mu_N2(T,pN2) ...
        	- 64*mu_solid('GaN',T,P) - 0.5*mu_O2(T,pO2);

cell = {'S_72', 'S_128'};
titlestring = {'Oxidation of GaN to Ga$_{36}$N$_{35}$O','Oxidation of GaN to Ga$_{64}$N$_{63}$O'};

for i = 1:length(cell)
figure;

%%%%%% Shade in above 0 %%%%%%%

[C2,h2] = contourf(T,pN2/1E5,Gibbs.(cell{i})/1E3,[0 200],'linewidth',1);
set(get(h2,'children'),'FaceColor',[0.6 0.6 0.6]);

hold on;
%%%%%%% Plot text and remaining contours %%%%%
[C,h] = contour(T,pN2/1E5,Gibbs.(cell{i})/1E3,'k');
%set(h,'ShowText','on');
set(gca,'YScale','log');
clabel(C,h,'LabelSpacing',200);
hold off;

xlabel('T / K','interpreter','latex');
ylabel('$p_{N_2} / $bar ($p_{O_2}$ fixed at 1 kPa)','interpreter','latex');

title(titlestring{i},'interpreter','latex');

end