%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%  Ga2O3_Cp_lit.m:  Comparative heat capacities of Ga2O3 from literature       %
%                  and ab-initio phonon calculations                           %
%                                                                              %
%  Note that thermal expansion is disregarded such that Cp and Cv are used     %
%  interchangably                                                              %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function Ga2O3_Cp_lit()

%% Fundamental constants and setup
k_B = 1.3806488E-23; % J/K
N_A = 6.02214129E23; % /mol

source = {'phonopy','Adams','Mills'};
linestyle = {'k-','k--','k:','k-.','ko'};
name = {'PBEsol with harmonic approximation','Calorimetry measurements by Adams (1952)'};
%% Ab initio results from phonopy-FHI-aims

FU.phonopy         = 4; % Formula units / unit cell

phonopy = importdata('data/Ga2O3/phonopy-FHI-aims-free_energy.dat');

data.('phonopy').T = phonopy.data(:,1);
data.('phonopy').Cp = phonopy.data(:,4)*k_B*N_A/FU.phonopy; % J/mol


%% Low-temperature data for Ga2O3 from Adams (1952)
%%%% Journal of the American Chemical Society 74 (19) 4788-9
%%%% by electrical heating
data.('Adams').T = [15.82
18.89
21.22
23.43
25.64
27.94
30.60
33.56
36.91
40.54
44.29
48.61
53.02
54.23
58.08
58.60
61.78
64.15
66.61
69.27
69.65
70.54
70.59
75.54
76.45
82.03
83.34
88.46
89.07
95.37
103.09
110.41
118.32
127.15
136.41
146.70
156.80
165.76
173.88
182.01
189.83
198.92
207.91
217.62
226.86
235.78
247.01
254.44
264.03
272.90
273.47
283.04
292.26
300.79];

% Heat capacity in cal/deg/mole
data.('Adams').Cp = [0.101
0.146
0.207
0.265
0.344
0.438
0.578
0.762
1.042
1.353
1.683
2.157
2.656
2.784
3.226
3.303
3.603
3.863
4.123
4.370
4.392
4.524
4.492
5.101
5.199
5.862
6.010
6.561
6.630
7.312
8.136
8.906
9.732
10.62
11.47
12.43
13.35
14.09
14.73
15.34
15.92
16.52
17.07
17.74
18.26
18.77
19.40
19.80
20.33
20.83
20.83
21.27
21.72
22.00];

% convert to J/molK

data.('Adams').Cp = data.('Adams').Cp*4.184;


%% High-temperature polynomial fit to experimental data from Mills (1972)
%%% "The heat capacities of Ga2O3(c),Tl2O3(c),ZnO(c), and CdO(c)"
%%% High Temperatures -- High Pressures, 4 pp. 271-377
% DCS and drop calorimetry
% T in K
data.('Mills').T = [298.15
    400
    500
    600
    700
    800
    900
    1000
    1100
    1200
    1300
    1400
    1500
    1600
    1700
    1800];
% Cp in J / mol K
data.('Mills').Cp = [93.83
    105.92
    112.20
    116.31
    119.41
    121.96
    124.19
    126.22
    128.13
    129.95
    131.71
    133.43
    135.11
    136.76
    138.40
    140.02];

%% Plotting

close all;
figure;
hold on
for i=1:length(source)
plot(data.(source{i}).T,data.(source{i}).Cp,linestyle{i});
end
hold off

box on;
axis([0 2000 0 150]);

xlabel('Temperature (K)','interpreter','latex');
ylabel('$C_p$ (J mol$^{-1}$ K$^{-1}$)','interpreter','latex');
%legend(name,'Location','SouthEast','interpreter','latex');

end
