%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% S_72_sub.m:       Script to plot free energy change of substitutional defect %
%                   formation in GaN over a range of temperatures and          %
%                   pressures                                                  %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [100:100:2000]; % set up T range

log10P = [0:2:6]'; % set up logarithmic P range
pO2 = 10.^log10P;
pN2 = 10.^log10P(end:-1:1);

P = pN2 + pO2; % Sum partial pressures (ideal behaviour)

Gibbs = mu_solid('S_72',T,P) + 0.5*mu_N2(T,pN2) ...
        	- 36*mu_solid('GaN',T,P) - 0.5*mu_O2(T,pO2);

plot(T,Gibbs'/1E3,'k');
hold on
plot([0 2000],[0 0],'k--');
axis([0 2000 -250 20]);

xlabel('T (K)','interpreter','latex');
ylabel('$\Delta G $ (kJ mol$^{-1}$)','interpreter','latex');

% titlestring = sprintf('Oxidation of GaN to Ga$_{36}$N$_{35}$O');
% title(titlestring,'interpreter','latex');

for i = 1:length(log10P)
line_label = sprintf('$[%1.0E , %1.0E]$', ...
		     pN2(i), pO2(i));
text(1400,Gibbs(i,end-6)/1E3,line_label,'interpreter','none');

end