%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%  conc_dependence_G.m: Plot the concentration dependence of the free energy   %
%                       of substitutional defect formation with and without    %
%                       band-filling correction                                %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

eV2J = 1.602176565E-19; % J/eV
N_A  = 6.02214129E23;   % /mol

pO2 = 1E-5;   % Oxygen pressure in Pa
pN2 = 1E1; % Nitrogen pressure in Pa
T = 500;  % Temperature in K

P = pO2 + pN2;

species = {'S_72','S_128'};
species_FU =  [36 64];
correction_eV = [-0.912450904044445 -0.703046388766667];
correction_Jmol = correction_eV * eV2J * N_A;

for i = 1:length(species)
Gibbs(i) = mu_solid(species{i},T,P) + 0.5*mu_N2(T,pN2) ...
    - species_FU(i)*mu_solid('GaN',T,P) -0.5*mu_O2(T,pO2);
end
Gibbs_corrected = Gibbs + correction_Jmol;

plot(species_FU,Gibbs/1E3,'ko');
hold on;
plot(species_FU,Gibbs_corrected/1E3,'k*');
hold off;

xlabel('GaN units in supercell','interpreter','latex');
ylabel('$\Delta G_{\text{defect}}$ / kJ mol$^{-1}$','interpreter','latex');

