%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% full_oxidation.m: Script to plot free energy change of oxidisation of        %
%                   GaN to Ga2O3 over a range of temperatures and pressures    %
%                                                                              %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [100:100:2000]; % set up T range

log10P = [1:2:6]'; % set up logarithmic P range
pO2 = 10.^log10P;
pN2 = 10.^log10P(end:-1:1);

P = pN2 + pO2; % Sum partial pressures (ideal behaviour)

Gibbs = mu_solid('Ga2O3',T,P) + mu_N2(T,pN2) ...
        	- 2*mu_solid('GaN',T,P) - 1.5*mu_O2(T,pO2);

plot(T,Gibbs'/1E3,'k');

xlabel('T (K)','interpreter','latex');
ylabel('$\Delta G$ (kJ mol$^{-1}$)','interpreter','latex');

% titlestring = sprintf('Oxidation of GaN to Ga$_2$O$_3$');
% title(titlestring,'interpreter','latex');

for i = 1:length(log10P)
line_label = sprintf('$[p_{\\text{N}_2} p_{\\text{O}_2}],  = [%1.0E , %1.0E]$', ...
		     pN2(i), pO2(i));
text(1400,Gibbs(i,end-6)/1E3,line_label,'interpreter','latex');

end