%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% full_oxidation.m: Script to plot free energy change of oxidisation of        %
%                   GaN to Ga2O3 over a range of temperatures and pressures    %
%                                                                              %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [100:100:2000]; % set up T range

log10P = [3:0.5:10]'; % set up logarithmic P range
pO2 = 10.^log10P;
pN2 = 1E1^1*ones(length(log10P),1); % Arbitrarily fix pN2

P = pN2 + pO2; % Sum partial pressures (ideal behaviour)

Gibbs = mu_solid('Ga2O3',T,P) + mu_N2(T,pN2) ...
        	- 2*mu_solid('GaN',T,P) - 1.5*mu_O2(T,pO2);

% Set up custom colour series

low_C = [0 0 1];
high_C = [1 0 0];
red   = linspace(low_C(1),high_C(1),length(T));
green = linspace(low_C(2),high_C(2),length(T));
blue  = linspace(low_C(3),high_C(3),length(T));
colourseries = [red' green' blue'];

set(0,'DefaultAxesColorOrder',colourseries)
        
plot(pO2/1E5,Gibbs/1E3);


xlabel('$p_{O_2}$ / bar','interpreter','latex');
ylabel('$\Delta G / $kJ mol$^{-1}$','interpreter','latex');
set(gca,'xscale','log');
titlestring = sprintf( ...
		      'Oxidation of GaN to Ga$_2$O$_3$ in %f bar N$_2$', ...
		      pN2(1)/1E5);
title(titlestring,'interpreter','latex');


set(gcf, 'Colormap', colourseries); % Set up graph colouring
caxis([T(1) T(end)]);

c = colorbar;
ylabel(c,'Temperature / K','interpreter','latex');