%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zero-point energies from literature
%
% Citation:
%
% Irikura, K. K. (2007). Journal of Physical and Chemical Reference Data, 
% 36(2), 389?397. doi:10.1063/1.2436891 
%
% 2010 CODATA recommended values
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

avhc = 0.119626565779; % J m / mol  (Avogadro constant * Planck constant * speed of light in vacuum)
h_eV = 4.135667516E-15; % eV s
c = 299792458; %m/s

zpe_O2_cm = 787.3806; % 1/cm
zpe_O2_Jmol = zpe_O2_cm*100*avhc; % J/mol
zpe_O2_eV = zpe_O2_cm*100*h_eV*c; % eV/molecule

zpe_N2_cm = 1175.78; % 1/cm
zpe_N2_Jmol = zpe_N2_cm*100*avhc; % J/mol
zpe_N2_eV = zpe_N2_cm*100*h_eV*c; % eV/molecule
