%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                      %
%        gibbs_examples.m              %                    
%                                      %
%      Sample values and relative      %
%    contributions to the Gibbs free   %
% energy of oxygen defect formation in %
%                 GaN                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = [2000];
P = [1E9]';
pO2=[0.5]'.*P;
pN2 = P - pO2;

eV2J = 1.602176565E-19; % J/eV
N_A  = 6.02214129E23;   % /mol
E_O2 = -4080.04839113411 * eV2J * N_A;
E_N2 = -2970.0835376944 * eV2J * N_A;

FU.('Ga')          = 8; % Formula units / unit cell
FU.('GaN')         = 2; % Formula units / unit cell
FU.('Ga2O3')       = 4; % Formula units / unit cell
FU.('S_72')        = 1; % Supercell
FU.('S_128')       = 1; % Supercell



Gibbs = mu_solid('S_128',T,P) + 0.5*mu_N2(T,pN2) ...
        	- 64*mu_solid('GaN',T,P) - 0.5*H_O2(T,pO2);
H = H_solid('S_128',T,P) + 0.5*H_N2(T,pN2) ...
        	- 64*H_solid('GaN',T,P) - 0.5*H_O2(T,pO2);
E = E_solid('S_128') + 0.5*E_N2 - 64*E_solid('GaN') - 0.5*E_O2;
        
fprintf(' T          P           DG       -TS          DH         intCp+PV        DE\n');
fprintf('(K)        (Pa)       (J/mol)   (J/mol)     (J/mol)     (J/mol)       (J/mol)\n');
 
for i = 1:length(T)
    fprintf('%7.2f %6.4e %6.4e %6.4e %6.4e %6.4e %6.4e\n',T(i),P(i),Gibbs(i,i), ...
        Gibbs(i,i)-H(i,i),H(i,i),H(i,i)-E,E);
end
