%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%   mu_O2(T,P): Chemical potential of O2 from DFT and thermodynamic data       %
%               where T is a row vector of temperatures in K and P is a column %
%               vector in Pa. mu_N2 is returned in J/mol                       %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% This program uses the external function files A_intCp.m and Sig.m            %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function mu =  mu_O2(T,P)

% Conversion factors
J_eV = 1.60217646E-19; % J/eV
av = 6.02214129E23;   % 1/mol

% Fundamental constants
R = 8.314;

% Standard conditions
P_standard = 10^5; % 1 bar expressed in Pa
T_standard = 298.15; % K

% mu = E_dft + ZPE + [H^th-H^0]        + RTln(p/p^th) + int(Cp dT)(T-T^th) - T*S(T,p^th)
% mu = E_dft + ZPE + standard_enthalpy + pressure_cor + temperature_cor    - TS         

E_dft_eV = -4080.04839113411;      % eV
E_dft = E_dft_eV * J_eV * av; % J/mol

gas_zpe;      % External file converts data from Irikura (2007)
ZPE = zpe_O2_Jmol; % J/mol

standard_enthalpy = 8680;     % J/mol from CRC Handbook 2012

pressure_cor = R*kron(T,log(P/P_standard)); % Kronecker tensor product gives all products as matrix

% Assuming independent of pressure
temperature_cor = A_IntCp('O2',T_standard,T)/1000; % Convert to J/mol
temperature_cor = kron(temperature_cor,ones(length(P),1));

S = Sig('O2',T,P_standard);
TS = kron(T.*S,ones(length(P),1));

mu = E_dft + ZPE + standard_enthalpy + pressure_cor + temperature_cor - TS; 
