%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%  normalised_Cp.m: Comparative heat capacities of compounds from              %
%                   ab-initio phonon calculations                              %
%                                                                              %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

species = {'Ga','Ga2O3','GaN','S_72','S_128'};
species_legend =  {'Ga','Ga$_{2}$O$_{3}$','GaN','Ga$_{36}$N$_{35}$O','Ga$_{64}$N$_{63}$O'};
species_marker={'ko-','ks-','kd-','k^-','kx-'};

FU.('Ga')          = 8; % Formula units / unit cell
FU.('GaN')         = 2; % Formula units / unit cell
FU.('Ga2O3')       = 4; % Formula units / unit cell
FU.('S_72')        = 1; % Formula units / unit cell
FU.('S_128')       = 1; % Formula units / unit cell

atoms.('Ga')       = 1; % Atoms / Formula unit
atoms.('GaN')      = 2; % Atoms / Formula unit
atoms.('Ga2O3')    = 5; % Atoms / Formula unit
atoms.('S_72')     = 72;% Atoms / Formula unit
atoms.('S_128')    = 128;% Atoms / Formula unit

interval=100;

close all;
figure;
hold on;

for i= 1:length(species)
thermal.(species{i}) = importdata(strcat('data/',species{i},'/phonopy-FHI-aims-free_energy.dat'));
plothandles(i) = plot(thermal.(species{i}).data(:,1),thermal.(species{i}).data(:,4)/(FU.(species{i})*atoms.(species{i})),species_marker{i});
end
hold off;

xlabel('Temperature / K', 'interpreter','latex');
ylabel('$C_v$ / $kB$ atom$^{-1}$','interpreter','latex');
legend(plothandles,species_legend,'interpreter','latex');

figure;
hold on;
plot(thermal.('S_72').data(:,1),(thermal.('S_72').data(:,4)) ...
                             - (thermal.('GaN').data(:,4)*atoms.('S_72')/(atoms.('GaN')*FU.('GaN'))),'k');
plot(thermal.('S_128').data(:,1),(thermal.('S_128').data(:,4)/(FU.('S_128'))) ...
                             - (thermal.('GaN').data(:,4)*atoms.('S_128')/(atoms.('GaN')*FU.('GaN'))),'k--');
xlabel('Temperature / K', 'interpreter','latex');
ylabel('$\Delta C_v$ / $kB$ atom$^{-1}$','interpreter','latex');
%text( 600,0.015,'$\Delta C_v = C_{v, \textrm{Ga$_{36}$N$_{35}$O}} - C_{v, 36\textrm{GaN}}$','interpreter','latex');
legend({'$\Delta C_v = C_{v, \textrm{Ga$_{36}$N$_{35}$O}} - C_{v, 36\textrm{GaN}}$' , ...
	'$\Delta C_v = C_{v, \textrm{Ga$_{64}$N$_{63}$O}} - C_{v, 64\textrm{GaN}}$'});
box on;
axis([0 2000 0 3.2]);