%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% phonon_curves.m: Plot phonon dispersion curves for publication from          %
%                  phonopy-FHI-aims data files                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

species = {'GaN','S_72','Ga2O3','Ga'};

bands.GaN = importdata('data/GaN/phonopy-FHI-aims-band_structure.dat', ' ',31);
dos.GaN = importdata('data/GaN/phonopy-FHI-aims-dos.dat');
bands.GaN.special_points={'H', 'L', '$\Lambda$', '$\Gamma$', '$\Delta$', 'U', 'K', 'H'};
bands.GaN.point_locations=[0 0.37268 1.01123 1.54573 1.92369 2.42369 2.95448 3.20448];

bands.S_72 = importdata('data/S_72/phonopy-FHI-aims-band_structure.dat', ' ',13);
dos.S_72 = importdata('data/S_72/phonopy-FHI-aims-dos.dat');
bands.S_72.special_points={'$\Gamma$', 'X'};
bands.S_72.point_locations=[0 1];

bands.Ga2O3 = importdata('data/Ga2O3/phonopy-FHI-aims-band_structure.dat',' ',25);
dos.Ga2O3 = importdata('data/Ga2O3/phonopy-FHI-aims-dos.dat');
bands.Ga2O3.special_points={'L','M','A','$\Gamma$','Y','V'};
bands.Ga2O3.point_locations=[0 0.5 1.20711 1.70711 2.41421 2.91421];

bands.Ga = importdata('data/Ga/phonopy-FHI-aims-band_structure.dat',' ',16);
dos.Ga = importdata('data/Ga/phonopy-FHI-aims-dos.dat');
bands.Ga.special_points={'Y','$\Gamma$','Z'};
bands.Ga.point_locations=[0 0.70711 1.20711];

for i = 1:length(species)

figure;

% We ask for threee subplots, but use two for the band structure to give a 
% pleasing ratio of widths
subplot(1,3,[1 2]);
plot(bands.(species{i}).data(:,1),bands.(species{i}).data(:,2:end),'k');
axis([0 bands.(species{i}).point_locations(end) 0 1.05*max(max(bands.(species{i}).data))]);
ylabel('Frequency / cm$^{-1}$','interpreter','latex');

set(gca,'XTick',bands.(species{i}).point_locations);
set(gca,'XTickLabel',bands.(species{i}).special_points)

subplot(1,3,3);
plot(dos.(species{i}).data(:,2),dos.(species{i}).data(:,1),'k');
axis([0 1.1*max(dos.(species{i}).data(:,2)) 0 1.05*max(max(bands.(species{i}).data))]);

% Currently need to set xtick=\empty by hand in pgfplots output

xlabel('Density of states');
set(gca,'XTickLabel','');
set(gca,'YTickLabel','');

end