%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%   E_solid: returns the ground state energy of solids from DFT calculations   %
%                                                                              %
%       usage: E = E_solid('species')                                          %
%                                                                              %
%     where E is the ground state energy in J/mol from PBEsol calculations     %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function E = E_solid(species)

eV2J = 1.602176565E-19; % J/eV
N_A  = 6.02214129E23;   % /mol

E_DFT_eV.('Ga')    = -0.425137737497745E6;  % eV (run 0222)
E_DFT_eV.('GaN')   = -0.109256874892143E6;  % eV (run 0234)
E_DFT_eV.('Ga2O3') = -0.449656504853252E6;  % eV (run 0230)
E_DFT_eV.('S_72')  = -0.196717956674226E7;  % eV (run 0164)
E_DFT_eV.('S_128') = -0.349677592856924E7;  % eV (run 0210)

FU.('Ga')          = 8; % Formula units / unit cell
FU.('GaN')         = 2; % Formula units / unit cell
FU.('Ga2O3')       = 4; % Formula units / unit cell
FU.('S_72')        = 1; % Supercell
FU.('S_128')       = 1; % Supercell

E = E_DFT_eV.(species)*eV2J*N_A/FU.(species); % J/mol
