%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%  conc_dependence_H.m: Plot the concentration dependence of the enthalpy      %
%                     of substitutional defect formation with and without      %
%                     band-filling correction                                  %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
%   Depends on external functions H_supercell, H_solid, H_N2, H_O2             %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

eV2J = 1.602176565E-19; % J/eV
N_A  = 6.02214129E23;   % /mol

pO2 = 2E4;   % Oxygen pressure in Pa
pN2 = 8E4; % Nitrogen pressure in Pa
T = 298.15;  % Temperature in K

P = pO2 + pN2;

species = {'S_72','S_128','S_300'};
species_FU =  [36 64 150];
correction_eV = [-0.912450904044445 -0.703046388766667 -0.518294558025000];
correction_Jmol = correction_eV * eV2J * N_A;

for i = 1:length(species)
%%%%%% Calculate defect formation enthalpy %%%%%%%%%
H(i) = H_supercell(species{i},T,P) + 0.5*H_N2(T,pN2) ...
    - species_FU(i)*H_solid('GaN',T,P) -0.5*H_O2(T,pO2);

%%%%%%% Calculate unit cell volume V= a.(bxc) %%%%%%%
geometry = importdata(strcat('data/',species{i},'/geometry.in'));
lattice = geometry.data(1:3,1:3);
V(i) = dot(lattice(1,:),cross(lattice(2,:),lattice(3,:)));
end
H_corrected = H + correction_Jmol;

plot(1./V,H/1E3,'ko');
hold on;
plot(1./V,H_corrected/1E3,'k*');
hold off;

xlabel('Defects \AA^{-3}','interpreter','latex');
ylabel('$\Delta H_{\text{defect}}$ / kJ mol$^{-1}$','interpreter','latex');

text(70,-140,'$x $GaN$ + 0.5 $O$_2 \rightarrow $Ga$_{x}$N$_{x-1}$O$ + 0.5 $N$_2$','interpreter','latex');

axis([0 1.4E-3 -180 -70]);
box on;