%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% Normalised_S.m:  Plot the entropy of solids from ab initio calculations,     %
%                  normalised to an atomic basis for ease of comparison.       %
%                                                                              %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

eV2J = 1.602176565E-19; % J/eV
N_A  = 6.02214129E23;   % /mol

species = {'Ga','Ga2O3','GaN','S_72'};
species_legend =  {'Ga','Ga$_{2}$O$_{3}$','GaN','Ga$_{36}$N$_{35}$O'};
species_linestyle={'k-.','k','k:','k--'};
atoms = [8 20 4 72];


close all;
figure;
hold on;

for i = 1:length(species)

thermal.(species{i})=importdata(strcat('data/',species{i},'/phonopy-FHI-aims-free_energy.dat'));

T.(species{i})=thermal.(species{i}).data(:,1);
S.(species{i})=-thermal.(species{i}).data(:,5)./T.(species{i}) * eV2J * N_A; % J / mol K
S_atom.(species{i}) = S.(species{i}) / atoms(i);

plot(T.(species{i}),S_atom.(species{i}),species_linestyle{i});

end

hold off;

xlabel('Temperature / K');
ylabel('$S$ / J mol$^{-1} $K$^{-1}$ (atom basis)');
legend(species_legend,'Location','SouthEast');
box on;