%%%%%% phonon_results_table.m %%%%%%%%%%%%%%%%%%%%%%
%
% Generate results table formatted for LaTeX
% from Phonopy calculations
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% GaN & [4 4 4] & [6 6 4] &  0.305 & 0.218 & 8.522 && 14.729 & 10.515 & 0.0354 

compounds = {'GaN', 'Ga', 'Ga2O3', 'S_72'};

av = 6.02214129E23;       % /mol
eV2kJ = 1.602176565E-22;   % eV/kJ
kB = 1.3806488E-23; % J/K

for i = 1:length(compounds)

    phonon = importdata(strcat('data/',compounds{i},'/phonopy-FHI-aims-free_energy.dat'));

    system_call1 = sprintf('grep "^[ ]*k_grid" data/%s/control.in | sed "s/k_grid //"|tr "\n" " "',compounds{i});
    [success, kgrid] = unix(system_call1);
    
    system_call2 = sprintf('grep "^[ ]*phonon supercell" data/%s/control.in | sed "s/phonon supercell //"|tr "\n" " "',compounds{i});
    [success, supercell] = unix(system_call2);
    
    warning('OFF', 'MATLAB:interp1:NaNinY'); % suppress error from interp1: NaN is usually well away from 298K
    warning('OFF','MATLAB:chckxy:IgnoreNaN');
    
    zpe = phonon.data(1,2);
    F_298 = interp1(phonon.data(:,1),phonon.data(:,2),298.15,'spline');
    C_298 = interp1(phonon.data(:,1),phonon.data(:,4),298.15,'spline');
    
    fprintf('%s & [%s] & [%s] & %.3f & %.3f & %.2f', ... 
        compounds{i},kgrid,supercell, zpe, F_298, C_298);
    
    switch compounds{i}
        case 'GaN'
            FU = 2;
        case 'Ga'
            FU = 8;
        case 'Ga2O3'
            FU = 4;
        case 'S_72'
            FU = 1;
        otherwise
            error('Need the number of forumula units (FU) in a unit cell')        
    end
   
    fprintf('&& %.2f & %.2f & %.2f \\\\ \n', ...
        zpe*eV2kJ*av/FU, F_298*eV2kJ*av/FU, C_298*kB*av/FU);
end