function [P, tc, SM_SR, WM, Downscaled] = DDS_Cal...
    (Lat,Sunrise_reg__Times,Sunset_reg_Times,Sunrise_leap_Times,Sunset_leap_Times,....
    Obs_Temper,Obs_SolRad,Obs_RelHum,Obs_wind_speed,Obs_wind_dir,Obs_Cloud,Obs_SurPress, Obs_Rain ,Longwave , Obs_Time)
 
%% Inputs
 
Calibrations Inputs: wind direction (o), wind speed (ms^-1), air temperature (C), relative humidity (%), pressure (Pascals), solar radiation (Wm^-2),  and cloud cover (oktas)

% Sunrise_Times = Time of Sunrise in the location of the weather data
% during a regular year
 
% Sunset_Times = Time of Sunrise in the location of the weather data
% during a regular year
 
% Sunrise_Times_Leap = Time of Sunrise in the location of the weather data
% during a leap year
 
% Sunset_Times_Leap = Time of Sunrise in the location of the weather data
% during a leap year
 
% Obs_Temper = Observed Temperature at the site used to tune the
% Prediction equation: Unit - C
 	
% Obs_SolRad = Observed Solar Radiation at the site used to tune the
% Prediction equation: Unit - Wm^-2
 
% Obs_RelHum  = Observed Relative Humidity at the site used to tune the
% Prediction equation: Unit - %
 
% Obs_WindSpedU = Observed Wind Speed U at the site used to tune the
% Prediction Observed: Unit - ms^-1
 
% Obs_WindSpedV = Observed Wind Speed V at the site used to tune the
% Prediction equation: Unit - ms^-1
 
% Obs_Cloud = Observed Cloud Cover at the site used to tune the
% Prediction equation: Unit - Okta
 
% Obs_SurPress = Observed Surface Pressure at the site used to tune the
% Prediction equation: Unit - Pascals

% Obs_Rain = Observed Precipitation at the site used to tune the
% Prediction equation: Unit - mday^-1
 
% Obs_Time = Times of the Observed Data 
 
%% Outputs
 
%P = delay between the time of solar maximum and the maximum daily temperature. 
 
%tc = Site specific time coefficient
 
%SM_SR = time of solar maximum
 
%Downscaled = Structure for Downscaled Weather and the Observed Weather Together 
 %Air Temperature: Unit - C
 %Wind Speed: Unit - ms^-1
 %Wind Direction: Unit - o
 %Relative humidity: Unit - decimal
 %Longwave: Unit - Wm^-2
 %solar radiation: Unit - Wm^-2
 %Pressure : Unit - Pascals
 %precipitation: Unit - mday^-1
 
%% Make Daily Averages
 
Day_Array = datetime(year(Obs_Time),month(Obs_Time),day(Obs_Time)); % Make a array of the days of observation and make unique array of days
Uni_Days = unique(Day_Array);
 
for Day_LV = 1:length(Uni_Days) % Loop through days
    
    idx = find(Uni_Days(Day_LV) == Day_Array);% find all indexes of the day
 
    % Create daily averages of weather factors
    
    AirTempMax_Day(Day_LV) = max(Obs_Temper(idx));
    AirTempMin_Day(Day_LV) = min(Obs_Temper(idx));
    Solar_Day(Day_LV) = nanmean(Obs_SolRad(idx));
    CloudCover_Day(Day_LV) = nanmean(Obs_Cloud(idx));
    Pressure_Day(Day_LV) = nanmean(Obs_SurPress(idx));
    RelHum_Day(Day_LV) = nanmean(Obs_RelHum(idx));
    dir_Day(Day_LV) = nanmean(Obs_wind_dir(idx));
    ws_Day(Day_LV) = nanmean(Obs_wind_speed(idx)); 
    rain_Day(Day_LV) = nanmean(Obs_Rain(idx)); 

    clear idx Day_LV  
end
 
%% Get Sunrise and Sunset times
 
uni_years = unique(year(Obs_Time)); % Find years of observations 
 
% Make empty arrays
Sunrise_Times = [];
Sunset_Times = [];
 
for sol_LV = 1:length(uni_years) % Loop Years
 
    % Leap Year Check
 
    if rem(uni_years(sol_LV),4) ==  0 && rem(uni_years(sol_LV),100) ~=  0
        leapyear_check = 1;
        else      
        if rem(uni_years(sol_LV),400) ==  0         
        leapyear_check = 1;
        else    
        leapyear_check = 0;  
        end
    end
    
    % Make Sun Rise and Sun Set Times depending on whether it was a leap
    % year or not.
 
    if leapyear_check == 1
        
        Sunrise_Times = vertcat(Sunrise_Times, datetime( uni_years(sol_LV), month(Sunrise_leap_Times),day(Sunrise_leap_Times) ...
            ,hour(Sunrise_leap_Times) , minute(Sunrise_leap_Times),second(Sunrise_leap_Times))) ;     % Sets Sunrise time for year of intreset 
        Sunset_Times =  vertcat(Sunset_Times,  datetime( uni_years(sol_LV), month(Sunset_leap_Times),day(Sunset_leap_Times) ...
            ,hour(Sunset_leap_Times) , minute(Sunset_leap_Times),second(Sunset_leap_Times))) ;  % Sets Sunset time for year of intreset 
 
    else
        
        Sunrise_Times =  vertcat(Sunrise_Times, datetime( uni_years(sol_LV), month(Sunrise_reg__Times),day(Sunrise_reg__Times) ...
            ,hour(Sunrise_reg__Times) , minute(Sunrise_reg__Times),second(Sunrise_reg__Times))) ;  % Sets Sunrise time for year of intreset
        Sunset_Times =  vertcat(Sunset_Times,  datetime( uni_years(sol_LV), month(Sunset_reg_Times),day(Sunset_reg_Times) ...
            ,hour(Sunset_reg_Times) , minute(Sunset_reg_Times),second(Sunset_reg_Times))) ;  % Sets Sunset time for year of intreset 
        
     end
 
  
end

%% Solar Radiation
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Get Solar Maximum
 
Day_Array = datetime(year(Obs_Time),month(Obs_Time),day(Obs_Time)); % Make a array of the days of observation and make unique array of days
Uni_Days = unique(Day_Array);
 
for Day_LV = 1:length(Uni_Days) % Loop through days
    
    idx = find(Uni_Days(Day_LV) == Day_Array);% find all indexes of the day
 
    [~,idx_sm] = max(Obs_SolRad(idx)); % Find times of solar maximum
    
    DM_Day(Day_LV) = hour(Obs_Time(idx(idx_sm))); % Get this as numbered hours
    
    clear idx Day_LV  
end
 
SM_SR = (nanmean(DM_Day)); %produce mean of solar maximum 

 
% Make empty array 
total_Sol = [];
total_Sol_Time = [];
 
    for day_var = 1:length(Uni_Days)
 
    indx = find(Uni_Days(day_var) == datetime(year(Sunrise_Times),month(Sunrise_Times),day(Sunrise_Times)));  % Lines up day with 
 
    SR = hour(Sunrise_Times(indx)) + (minute(Sunrise_Times(indx))/60); % Sets Sunrise Time
    SS = hour(Sunset_Times(indx)) + (minute(Sunset_Times(indx))/60);  % Sets Sunset Time
                
    DL = (SS - SR); % Calculate Day length
    
    clear SR SS
    
    Total_Rad = (Solar_Day(day_var)) * (24*3600); % Turn mean Watts into joule 
 
    declin = 23.45 * sin(0.0174533 * (360/365) * (284 + day(Uni_Days(day_var), 'dayofyear')));  %Solar declination
 
    SD = sind(Lat) * sind(declin); % Seasonal offs
    CD = cosd(Lat) * cosd(declin); % Amplitude of the sine wave
 
    C = 0.4; % Meteorological characteristic defining dependence of transmissivity on solar height 
    
    Period = 0:0.5:23.5; %Period array in hours
 
    count = 0; % Start count value
 
        for II = Period
        
        count = count + 1;  % increase Count 
        
        sin_fb = SD + (CD * cos(pi*((II-SM_SR)/12)) );  % sine of the solar elevation
    
        DSBE = acos(-SD/CD) * (24/pi) * ( SD + (C*(SD^2)) + ((C*(CD^2)) / (2))) ...
        + (12*CD *(2+(3*C*SD))*((sqrt(1 - ((SD/CD)^2))) / (pi)) ); % integral of solar evaluation from sunrise to sunset
    
        Ra(count) =  Total_Rad * sin_fb * ((1 + (C*sin_fb)) / (DSBE*3600));  % Calculate radiation at each point
        
        clear II DSBE sin_fb
        end
    
    Ra(Ra < 0) = 0; % Flattens night time 
 
    % Adds time and Value into series array
    total_Sol = [total_Sol Ra];
    total_Sol_Time = [total_Sol_Time datetime(datenum(year(Uni_Days(day_var)),month(Uni_Days(day_var)),day(Uni_Days(day_var)),Period,0,0),'convertfrom','datenum')];
 
    clear Ra Period count C declin DL SS SR indx CD SD day_var Total_Rad
    end
 
Shared_Time_Array = [max([min(total_Sol_Time) min(Obs_Time)]):1/24:min([max(total_Sol_Time) max(Obs_Time)])];  % Make shared time
 
MIS = interp1(total_Sol_Time  ,total_Sol , Shared_Time_Array); % Modelled data of interests
OIS = interp1(Obs_Time ,Obs_SolRad , Shared_Time_Array);  % Observations data of interests  
 
clear total_Sol_Time total_Sol
 
RMSE = sqrt(nanmean((MIS-OIS).^2));% calculate RMSE
 
% Plot Solar Radiation
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS);
hold on;
plot(Shared_Time_Array,OIS)
t = text(4,900,sprintf('RMSE: %.4f (W/m^2)',RMSE));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Solar Radation (W/m^2)')
set(gca,'FontSize',20)
title('\fontsize{24} Solar Radation')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
% Save these variables into downscaled structure
Downscaled.Solar.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.Solar.Modelled = timeseries(MIS,datestr(Shared_Time_Array));
 
clear Shared_Time_Array OIS MIS RMSE t
 
%% Temperature Downscaling
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Tune Equation
P_var = 0:1:4; % delay between the time of solar maximum and the maximum daily temperature. 
tc_var = 3:1:5; % Site specific  time coefficient
SolMax = SM_SR; % Times of Solar Maximum 
 
    for PLV = 1:length(P_var) % loop through
        for tcLV = 1:length(tc_var)
            for SHLV = 1:length(SolMax) % loop through Solar Maximum 
            
            % Make empty arrays
            total_T = [];
            total_T_Time = [];    
          
                for day_var = 1:length(Uni_Days) - 1 % Loop Through Days (since loop runs from sunrise on day one to sunrise on day two one day is removed from the end)
                    
                % Set Tuning parameters    
                P =  P_var(PLV);
                tc =  tc_var(tcLV);
                SM =  SolMax(SHLV);   
                
                indx = find(Uni_Days(day_var) == datetime(year(Sunrise_Times),month(Sunrise_Times),day(Sunrise_Times))); % Find Sunrise and Sunset for current day
 
                SR = hour(Sunrise_Times(indx)) + minute(Sunrise_Times(indx))/60; % Find sunrise for day 
                SR_ND = hour(Sunrise_Times(indx + 1)) + minute(Sunrise_Times(indx+1))/60; % Find sunrise for next day
                SS = hour(Sunset_Times(indx)) + minute(Sunset_Times(indx))/60; % Find Sunset Time
          
                DL = (SS - SR); % Find day legnth
                
                Temperature_Diff = (AirTempMax_Day(day_var) - AirTempMin_Day(day_var)); % find temperature differnce
                
                Period = (SR+1:0.5:23+SR_ND); % Get period for days being considered between sunrise on day 1 to sunrise day 2
 
                [~,found_val] = min(abs(Period - SS)); % Find the moment of sun set
    
                count = 0; % Set count to 0
 
                    for II = SR+1:0.5:23+SR_ND % loop through period 
 
                    count = count + 1; % increase count
 
                        if count == found_val-1 %Swtich for day and night 
                        Tss = Ta(count-1);     % Set Sun set temperature 
                        end 
 
                        if  II < SS % %Swtich for day and night 
                        Function_of_Time = sin(pi*(II - SM + (DL/2))/(DL + (2*P))); % Sine wave function of time 
                        Ta(count) =  AirTempMin_Day(day_var) + (Temperature_Diff*Function_of_Time); % Day Time estimation of temperature
                        elseif SS <= II
                        Ta(count) = ( AirTempMin_Day(day_var+1) - (Tss * exp(-((24 - DL)/(tc)))) + ...
                            (Tss - AirTempMin_Day(day_var+1)) * exp(-((II - SS)/(tc))) / (1 - exp(-((24 - DL)/(tc))))); % Night Time estimation of temperature
                        end
                    
                    clear II 
                    end
 
                total_T = [total_T Ta]; % Add Temperature
                total_T_Time = [total_T_Time datetime(datenum(year(Uni_Days(day_var)),month(Uni_Days(day_var)),day(Uni_Days(day_var)),Period,0,0),'convertfrom','datenum')]; % Add Temperature Time
 
                clear day_var Ta Period found_val P tc SM indx SR SR_ND SS DL Temperature_Diff count Tss
                
                end
                
            Shared_Time_Array = [max([min(total_T_Time) min(Obs_Time)]):1/24:min([max(total_T_Time) max(Obs_Time)])]; % Makes a shared time step for sake of comparison
 
            MIS = interp1(total_T_Time ,total_T , Shared_Time_Array)'; % Interpolate modelled data Shared time step
            OIS = interp1(Obs_Time ,Obs_Temper , Shared_Time_Array)';% Interpolate observed data Shared time step
 
            RMSE(PLV,tcLV,SHLV) = sqrt(nanmean((MIS-OIS).^2));  % Calculate RMSE
            BIAS(PLV,tcLV,SHLV) = nansum(MIS-OIS) / length(MIS); % Calculate Bias
            
            Domain_Test(PLV,tcLV,SHLV) =  RMSE(PLV,tcLV,SHLV) + (1i* BIAS(PLV,tcLV,SHLV)); % Place error measures into an 2d array
 
            MIS_Array(PLV,tcLV,SHLV,:) = MIS; % Place  modelled data  into an 2d array
            OIS_Array(PLV,tcLV,SHLV,:) = OIS; % Place observed data into an 2d array
            
            clear MIS OIS SHLV 
            end
        clear tcLV    
        end
    clear PLV
    end
    
 Check = abs(RMSE + (1i * BIAS));
      
[i , j , k] = ind2sub(size(Check),find(abs(Check) == min(min(min(abs(Check)))))); % Bias was used as the main error message as some combinations caused underestimations of modelled temperature.
 
i = i(1); % Pick best solar maximum and  maximum temperature delay
j = j(1); % Pick best Site specific  time coefficient
k = k(1); % Pick best solar maximum
 
P = P_var(i); % Set up tuning parameter for solar maximum and  maximum temperature delay
tc = tc_var(j); % Set up tuning parameter for Site specific  time coefficient
SM = SolMax(k) ; % Set up tuning parameter for Solar maximum
 
MIS = squeeze(MIS_Array(i , j , k,:));  % get best Modelled Data 
OIS = squeeze(OIS_Array(i , j , k,:));  % get Modelled Data 
RMSE_oi = squeeze(RMSE(i , j , k));  % get corresponding RMSE
BIAS_oi = squeeze(BIAS(i , j , k));  % get corresponding Bias 
  
% Plot Temperature Data
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, real(MIS));
hold on;
plot(Shared_Time_Array,OIS)
t = text(4,28,sprintf('RMSE: %.4f°C',RMSE_oi));
t.FontSize = 20;
t = text(4,26,sprintf('BIAS: %.4f',BIAS_oi));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Temperature (°C)')
set(gca,'FontSize',20)
title('\fontsize{24} Air Temperature')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
% Save modelled temperature to use for relative humidity 
RH_Temp = MIS;
RH_Temp_Time = Shared_Time_Array;
 
% Save these varaibles into downscalled structure
Downscaled.Temp.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.Temp.Modelled = timeseries(MIS,datestr(Shared_Time_Array));
 
 
%% Relative Humidity (RH)
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Set empty array
total_RH = [];
total_RH_Time = [];
 
    for rhlv = 1:length(Uni_Days) %% Loop through days
 
    TA = nanmean([AirTempMax_Day(rhlv) AirTempMin_Day(rhlv)]); % Get an aevrge temerpature
 
    RH = RelHum_Day(rhlv);% Get daily RH
        
    es = 6.107 * exp((TA * 17.4) /(239 + TA)); % saturated vapour pressure
    VPA = (((RH)*es)/(100)); % actual vapour pressure 
 
    TD_Array = -10:0.5:30; % Range of Dew Point Temperature
 
        for TD_Numerical = 1:length(TD_Array) % Loop through range 
        Zero_array(TD_Numerical) = ( 6.107*exp((TD_Array(TD_Numerical) * 17.4) /(239 + TD_Array(TD_Numerical)))) - VPA; % Numerical estimation of dew point temperature
        clear TD_Numerical
        end
        
    clear TA
 
    [~,Zero_Location] =  min(abs(Zero_array)); % Find closest dew point estimation to Zero
 
    TD_est = TD_Array(Zero_Location); % get dew point estimation
    
    clear Zero_Location Zero_array TD_Array
 
    day_indx  = find(Uni_Days(rhlv) == datetime(year(RH_Temp_Time),month(RH_Temp_Time),day(RH_Temp_Time))); % find correct downscaled temperature for relative humidity day
    
    VPA = 6.107 * exp((TD_est * 17.4) /(239 + TD_est));  % Recalculate actual vapour pressure 
    VPA_calc(rhlv) = VPA; % Save actual vapour pressure 
    TD = RH_Temp (day_indx); % Get daily downscaled daily temperature
  
        for II = 1:length(day_indx)
        es = 6.107 * exp((TD((II)) * 17.4) /(239 + TD((II)))); % Recalculate saturated vapour pressure 
        RH(II)  = VPA/es; % Recalculate RH 
        clear II es
        end
        
    % Save Varibales
    total_RH = [total_RH RH];
    total_RH_Time = [total_RH_Time RH_Temp_Time(day_indx)];
    
    clear RH rhlv VPA TD day_indx TD_est 
    
    end
 
clear RH_Temp_Time RH_Temp
    
Shared_Time_Array = [max([min(total_RH_Time) min(Obs_Time)]):1/24:min([max(total_RH_Time) max(Obs_Time)])]; % Make shared time
 
total_RH(total_RH > 1) = 1; % correct overestimations to useable range

MIS = interp1(total_RH_Time ,total_RH , Shared_Time_Array) * 100; % Modelled data of interests
OIS = interp1(Obs_Time ,Obs_RelHum , Shared_Time_Array); % Observations data of interests 
 
clear total_RH_Time
  
RMSE = sqrt(nanmean((MIS-OIS).^2)); % calculate RMSE
    
% Plot RH
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS);
hold on;
plot(Shared_Time_Array,OIS)
t = text(4,0.90,sprintf('RMSE: %.4f %',RMSE));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Relative Humidity (%)')
set(gca,'FontSize',20)
title('\fontsize{24} Relative Humidity')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
% Save these varaibles into downscalled structure
Downscaled.RH.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.RH.Modelled = timeseries(MIS,datestr(Shared_Time_Array));
 
clear Shared_Time_Array MIS OIS RMSE t
 
%% Longwave & Cloud Cover
 
% Comparison of algorithms for incoming atmospheric long-wave radiation (G.
% N. Flerchinge et al 2009)
 
% Set empty array
DS_Longwave = [];
 
    for lwlv = 1:length(Uni_Days)
        
    eclr = 0.83 - (0.18 * (10^(-0.067 * VPA_calc(lwlv)))); % Clear-Sky Emissivity (angstrom 1918)
    
    C_temp = CloudCover_Day(lwlv)/8; % get daily cloud cover (and turn it into a fraction)
    
    Ec = ((1 - (0.84*C_temp)) * eclr) + (0.84 * C_temp); % Clear-Sky Emissivity or Clear-Sky Long-Wave Radiation for Cloudy Days (Unsworth and Monteith)  
    
    SBC = 5.670367 * 10^-8; % Stefan-Boltzmann constant
 
    day_indx  = find(Uni_Days(lwlv) == datetime(year(total_T_Time),month(total_T_Time),day(total_T_Time))); % find corersponding days
 
    TD = total_T(day_indx); % Get downscaled temperature 
    
    clear TD_Array TD_est
 
        for II = 1:length(day_indx)
        LW(II) = Ec*SBC*((TD(II) + 273.15)^4); % Calculate Long wave radiation
        clear II
        end
        
    DS_Longwave = [DS_Longwave LW]; % Add into total array
    
    clear LW TD
    
    end 
 
Shared_Time_Array = [max([min(total_T_Time) min(Obs_Time)]):1/24:min([max(total_T_Time) max(Obs_Time)])]; % Make shared time
 
MIS = interp1(total_T_Time ,DS_Longwave , Shared_Time_Array); % Modelled data of interests
OIS = interp1(Obs_Time ,Longwave , Shared_Time_Array); % Observations data of interests 
 
RMSE = sqrt(nanmean((MIS-OIS).^2)); % calculate RMSE
    
% Plot Long Wave
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS);
hold on;
plot(Shared_Time_Array,OIS)
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} LongWave')
set(gca,'FontSize',20)
title('\fontsize{24} LongWave')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
t = text(4,400,sprintf('RMSE: %.4f (Unit)',RMSE));
t.FontSize = 20;
 
% Save these variables into downscaled structure
Downscaled.Longwave.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.Longwave.Modelled = timeseries(MIS,datestr(Shared_Time_Array));
 
clear t Shared_Time_Array MIS OIS RMSE
 

%% Wind Factors
 
% Based on A novel method to downscale daily wind statistics to hourly wind
% data for wind erosion modelling (Z Guo et al, 2015)

Day_Array = datetime(year(Obs_Time),month(Obs_Time),day(Obs_Time)); % Make a array of the days of observation and make unique array of days
Uni_Days = unique(Day_Array);
 
for Day_LV = 1:length(Uni_Days) % Loop through days
    
    idx = find(Uni_Days(Day_LV) == Day_Array);% find all indexes of the day
 
    [~,idx_sm] = max(Obs_wind_speed(idx)); % Find times of Wind maximum
    
    WM_Day(Day_LV) = hour(Obs_Time(idx(idx_sm))); % Get this as numbered hours
    
    clear idx Day_LV  
end
 
WM = (nanmean(WM_Day)); %produce mean of solar maximum 
 
% Transform
 
u_Day = -(abs(ws_Day)) .* sind(dir_Day); %Calculate U components from speed
v_Day = -(abs(ws_Day)) .* cosd(dir_Day); %Calculate V components from speed
 
% Create empty arrays 
total_WS = [];
total_WD = [];
total_Wind_Time = [];
 
    for I = 1:length(Uni_Days) 
 
    U_DA = u_Day(I);  % get U wind speed for day of interest      
    V_DA = v_Day(I);  % get V wind speed for day of interest    
 
    count = 0;  % Start count value 
 
        for II = 0:23  % loop through hours
        
        count = count + 1;  % Increase count
    
        U(count)  = U_DA + (0.5*U_DA*cos((((II-WM)*pi)/12))); % Applies the sine wave around the U wind speed
        V(count)  = V_DA + (0.5*V_DA*cos((((II-WM)*pi)/12))) ;% Applies the sine wave around the V wind speed
    
        clear II
        end
        
    clear count
    
    wind_speed = sqrt((U.^2)+(V.^2)); % Create wind speed from U and V components 
    wind_angle = (atan2((U),(V)) * (180/pi)) + 180; % Creates meteorological wind direction
        
    clear US VS
 
    % Adds time and Value into series array    
    total_WD = [total_WD wind_angle];
    total_WS = [total_WS wind_speed];
    total_Wind_Time = [total_Wind_Time datetime(datenum(year(Uni_Days(I)),month(Uni_Days(I)),day(Uni_Days(I)),0:23,0,0),'convertfrom','datenum')];
 
    clear WS wind_angle wind_speed U V U_DA V_DA I
    end
    
Shared_Time_Array = [max([min(total_Wind_Time) min(Obs_Time)]):1/24:min([max(total_Wind_Time) max(Obs_Time)])];   % Make shared time
 
MIS_WS = interp1(total_Wind_Time ,total_WS , Shared_Time_Array); % Modelled Wind Speed of interests
OIS_WS = interp1(Obs_Time ,Obs_wind_speed , Shared_Time_Array);  % Observations Wind Speed of interests
 
% Save these varaibles into downscaled structure
Downscaled.WS.Observed = timeseries(OIS_WS,datestr(Shared_Time_Array));
Downscaled.WS.Modelled = timeseries(MIS_WS,datestr(Shared_Time_Array));
 
RMSE_WS = sqrt(nanmean((MIS_WS-OIS_WS).^2)); % calculate wind speed RMSE 
 
MIS_WD = interp1(total_Wind_Time ,total_WD , Shared_Time_Array); % Modelled Wind Speed of interests
OIS_WD = interp1(Obs_Time ,Obs_wind_dir , Shared_Time_Array); % Observations Wind Speed of interests
 
RMSE_WD = sqrt(nanmean((MIS_WD-OIS_WD).^2));% calculate wind Dir RMSE 
 
% Save these varaibles into downscaled structure
Downscaled.WD.Observed = timeseries(OIS_WD,datestr(Shared_Time_Array));
Downscaled.WD.Modelled = timeseries(MIS_WD,datestr(Shared_Time_Array));
 
% Plot Wind and Direction 
 
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS_WS);
hold on;
plot(Shared_Time_Array,OIS_WS)
t = text(4,12,sprintf('RMSE: %.4f m/s',RMSE_WS));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Wind Speed (m/s)')
set(gca,'FontSize',20)
title('\fontsize{24} Wind Speed')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
clear OIS_WS MIS_WS RMSE_WS t
 
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS_WD);
hold on;
plot(Shared_Time_Array,OIS_WD)
t = text(4,180,sprintf('RMSE: %.4f  °',RMSE_WD));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Wind Direction (°)')
set(gca,'FontSize',20)
title('\fontsize{24} Wind Direction')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
clear Shared_Time_Array OIS_WD MIS_WD RMSE_WD t
 
%% Pressure Downscaling
 
% Make Empty Arrays
SP_total = [];
SPTIME = [];
 
    for sp_lv = 1:length(Uni_Days) 
 
    day_indx  = find(Uni_Days(sp_lv) == datetime(year(Obs_Time),month(Obs_Time),day(Obs_Time))); % find all instances within day
 
        for II = 1:length(day_indx)
        SP(II)  = Pressure_Day(sp_lv); % apply daily value to all day instances
        clear II
        end
 
    % Adds time and Value into series array    
    SP_total = [SP_total SP];
    SPTIME = [SPTIME Obs_Time(day_indx)];
    clear SP sp_lv day_indx
    end
 
Shared_Time_Array = [max([min(SPTIME) min(Obs_Time)]):1/24:min([max(SPTIME) max(Obs_Time)])]; % Make shared time
 
MIS = interp1(SPTIME ,SP_total , Shared_Time_Array); % Modelled data of interests
OIS = interp1(Obs_Time ,Obs_SurPress , Shared_Time_Array);  % Observations data of interests  
 
% Save these variables into downscaled structure
Downscaled.SP.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.SP.Modelled = timeseries(MIS,datestr(Shared_Time_Array));
 
RMSE = sqrt(nanmean((MIS-OIS).^2));    % calculate RMSE
    
% Plot Pressure
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS);
hold on;
plot(Shared_Time_Array,OIS)
t = text(4,980,sprintf('RMSE: %.4f',RMSE));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Surface Pressure')
set(gca,'FontSize',20)
title('\fontsize{24} Surface Pressure')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
clear Shared_Time_Array MIS OIS RMSE t 
 
%% Rain Downscaling
 
% Make Empty Arrays
Rain_total = [];
RainTIME = [];
 
    for Rain_lv = 1:length(Uni_Days) 
 
    day_indx  = find(Uni_Days(Rain_lv) == datetime(year(Obs_Time),month(Obs_Time),day(Obs_Time))); % find all instances within day
 
        for II = 1:length(day_indx)
        Rain(II) = rain_Day(Rain_lv); % apply daily value to all day instances
        clear II
        end
 
    % Adds time and Value into series array    
    Rain_total = [Rain_total Rain];
    RainTIME = [RainTIME Obs_Time(day_indx)];
    clear Rain Rain_lv
    end
 
Shared_Time_Array = [max([min(RainTIME) min(Obs_Time)]):1/24:min([max(RainTIME) max(Obs_Time)])]; % Make shared time
 
MIS = interp1(RainTIME ,Rain_total , Shared_Time_Array); % Modelled data of interests
OIS = interp1(Obs_Time ,Obs_Rain , Shared_Time_Array);  % Observations data of interests 

Downscaled.Rain.Observed = timeseries(OIS,datestr(Shared_Time_Array));
Downscaled.Rain.Modelled = timeseries(MIS,datestr(Shared_Time_Array));

RMSE = sqrt(nanmean((MIS-OIS).^2));    % calculate RMSE
    
% Plot Pressure
figure('units','normalized','outerposition',[0 0 1 1]); set(gcf,'color','w');
plot(Shared_Time_Array, MIS);
hold on;
plot(Shared_Time_Array,OIS)
t = text(4,max(OIS),sprintf('RMSE: %.4f',RMSE));
t.FontSize = 20;
xlabel('\fontsize{22} Date')
ylabel('\fontsize{22} Precipitation per day (m)')
set(gca,'FontSize',20)
title('\fontsize{24} Precipitation')
xlim([min(Shared_Time_Array) max(Shared_Time_Array)])
 
clear Shared_Time_Array MIS OIS RMSE t 



end

