function [DS_Temperature, DS_Solar, DS_WD, DS_WS, DS_RH, DS_SP, DS_Longwave, DS_Rain , DS_Time_Array] = DDS_Fut(Lat,Sunrise_reg__Times,Sunset_reg_Times,Sunrise_leap_Times,Sunset_leap_Times,....
    Daily_Temp_Min,Daily_Temp_Max,Daily_SolRad,Daily_RelHum, Daily_WindSpedU,Daily_WindSpedV,Daily_Cloud,Daily_SurPress, Daily_Rain ,Daily_Time,...
    P, tc, SM_SR, WM)
 
%% Inputs
 
% Daily_Temp_Min = Minimum Temperature Data for Downscaling: Unit - C
 
% Daily_Temp_Max = Maximum Temperature Data for Downscaling: Unit - C 
 
% Daily_SolRad =  Solar Radiation Mean Data for Downscaling: Unit - Wm^-2
 
% Daily_RelHum =  Relative Humidity Mean Data for Downscaling: Unit - %
 
% Daily_WindSpedU = Wind Speed U Mean Data for Downscaling: Unit - ms^-1
 
% Daily_WindSpedV = Wind Speed V Mean Data for Downscaling: Unit - ms^-1
 
% Daily_Cloud = Cloud Cover Mean Data for Downscaling: Unit - %

% Daily_Precipitation = Rainfall Mean Data for Downscaling: Unit - mday^-1
 
% Daily_SurPress = Pressure Mean Data for Downscaling: Unit - Pascals
 
% Daily_Time = Daily Time Array
 
% P = delay between the time of solar maximum and the maximum daily
% temperature: Unit - Hours
 
% tc = Site specific time coefficient: Unit - Hours
  
% SM_SR = Solar : Unit - Hours
 
%% Outputs
 
% DS_Temperature = Downscaled Temperature for Downscaling : Unit - C
 
% DS_Solar = Downscaled Solar Radiation Data for Downscaling: Unit - Wm^-2 
 
% DS_WD = Downscaled Wind Direction Data for Downscaling: Unit - degree 
 
% DS_WS = Downscaled Wind Speed Data for Downscaling: Unit - ms^-1 
 
% DS_RH = Downscaled Relative Humidity Data for Downscaling: Unit -decimal
 
% DS_SP = Downscaled Pressure Data for Downscaling : Unit - Pascals
  
% DS_Longwave = Downscaled Longwave Data for Downscaling : Unit - Wm^-2 

% DS_Rain = Downscaled Rainfall Data for Downscaling: Unit - mday^-1
 
% DS_Time_Array = Downscaled Time Array 
 
%% Get Sunrise and Sunset times
 
%Find Downscaled Years
uni_years = unique(year(Daily_Time));
 
% Make Empty Arrays
Sunrise_Times = [];
Sunset_Times = [];
 
for sol_LV = 1:length(uni_years) % Loop through years
 
    % Leap Year check
    if rem(uni_years(sol_LV),4) ==  0 && rem(uni_years(sol_LV),100) ~=  0
    leapyear_check = 1;
    else      
    if rem(uni_years(sol_LV),400) ==  0         
    leapyear_check = 1;
    else    
    leapyear_check = 0;  
    end
    end
    
    % Sets Sun Rise and Sun Set times for the downscaling years
    if leapyear_check == 1
 
    DS_sol_SR = Sunrise_leap_Times;
    DS_sol_SS = Sunset_leap_Times;
 
    else    
 
    DS_sol_SR = Sunrise_reg__Times;
    DS_sol_SS = Sunset_reg_Times;
 
    end
 
  
end
 
%% Solar Rad Downscaling
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Make Empty Arrays
DS_Solar = [];
Ds_Solar_Time = [];
 
    for day_var = 1:length(Daily_Time)
                
    indx = find(Daily_Time(day_var) == datetime(year(Daily_Time(day_var)),month(DS_sol_SR),day(DS_sol_SR))); % Lines up day with 
    
    SR = hour(DS_sol_SR(indx)) + minute(DS_sol_SR(indx))/60; % Sets Sunrise Time
    SS = hour(DS_sol_SS(indx)) + minute(DS_sol_SS(indx))/60; % Sets Sunset Time
    
    DL = (SS - SR); % Calculate Day length
    
    clear SR SS
    
    Total_Rad = (Daily_SolRad(day_var)) * (24*3600);  % Turn mean Watts into joule 
 
    declin = 23.45 * sin( (pi/180) * (360/365) * (284 + day(Daily_Time(day_var), 'dayofyear'))); %Solar declination
 
    SD = sind(Lat) * sind(declin); % Seasonal offs
    CD = cosd(Lat) * cosd(declin); % Amplitude of the sine wave
 
    C = 0.4; % Meteorological characteristic defining dependence of transmissivity on solar height 
    
    Period = 0:0.5:23.5; %Period array in hours
 
    count = 0; % Start count value
 
        for II = Period
        
        count = count + 1; % increase Count 
        
        sin_fb = SD + (CD * cos(pi*((II-SM_SR)/12)) ); % sine of the solar elevation
    
        DSBE = acos(-SD/CD) * (24/pi) * ( SD + (C*(SD^2)) + ((C*(CD^2)) / (2))) ...
        + (12*CD *(2+(3*C*SD))*((sqrt(1 - ((SD/CD)^2))) / (pi)) ); % integral of solar evaluation from sunrise to sunset
    
        Ra(count) =  Total_Rad * sin_fb * ((1 + (C*sin_fb)) / (DSBE*3600)); % Calculate radiation at each point
        
        clear II DSBE sin_fb
        end
    
    Ra(Ra < 0) = 0; % Flattens night time 
 
    % Adds time and Value into series array
    DS_Solar = [DS_Solar Ra];
    Ds_Solar_Time = [Ds_Solar_Time datetime(datenum(year(Daily_Time(day_var)),month(Daily_Time(day_var)),day(Daily_Time(day_var)),Period,0,0),'convertfrom','datenum')];
   
    clear Ra Period count C declin DL SS SR indx CD SD day_var Total_Rad
    end
 
% Convert into hourly
DS_Solar = interp1(Ds_Solar_Time ,DS_Solar , min(Ds_Solar_Time):1/24:max(Ds_Solar_Time))';
Ds_Solar_Time = min(Ds_Solar_Time):1/24:max(Ds_Solar_Time);    
 
clear Daily_SolRad SM Obs_SolRad Solar_Day

%% Temperature
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Make Empty Arrays
DS_Temperature = [];
DS_Temp_Time = [];
    
    for DT_LV = 1:length(Daily_Time) - 1
                
    indx = find(Daily_Time(DT_LV) == datetime(year(Daily_Time(DT_LV)),month(DS_sol_SR),day(DS_sol_SR))); % Find Sunrise and Sunset for current day
    
    SR = hour(DS_sol_SR(indx)) + minute(DS_sol_SR(indx))/60; % Find sunrise for day
    SR_ND = hour(DS_sol_SR(indx + 1)) + minute(DS_sol_SR(indx+1))/60; % Find sunrise for next day
    SS = hour(DS_sol_SS(indx)) + minute(DS_sol_SS(indx))/60; % Find Sunset Time
           
    DL = (SS - SR); % Find day length 
                
    Temperature_Diff = (Daily_Temp_Max(DT_LV) - Daily_Temp_Min(DT_LV));  % find temperature differnce
                
    Period = (SR+1:0.5:23+SR_ND); % Get period for days being considered between sunrise on day 1 to sunrise day 2
 
    [~,found_val] = min(abs(Period - SS)); % Find the moment of sun set
    
    count = 0; % Set count to 0 
 
        for II = SR+1:0.5:23+SR_ND  % loop through period 
 
        count = count + 1; % increase count 
 
             if count == found_val-1 
             Tss = Ta(count-1); % Set Sun set temperature 
             end 
 
             if  II <= SS % %Swtich for day and night 
             Function_of_Time = sin(pi*(II - SM_SR + (DL/2))/(DL + (2*P))); % Sine wave function of time 
             Ta(count) =  Daily_Temp_Min(DT_LV) + (Temperature_Diff*Function_of_Time); % Day Time estimation of temperature
             elseif SS < II
             Ta(count) = ( Daily_Temp_Min(DT_LV+1) - (Tss * exp(-((24 - DL)/(tc)))) +  (Tss - Daily_Temp_Min(DT_LV+1)) ...
                 * exp(-((II - SS)/(tc))) / (1 - exp(-((24 - DL)/(tc))))); % Night Time estimation of temperature
             end
        
        clear II Function_of_Time    
        end   
 
   DS_Temperature = [DS_Temperature Ta];
   DS_Temp_Time = [DS_Temp_Time datetime(datenum(year(Daily_Time(DT_LV)),month(Daily_Time(DT_LV)),day(Daily_Time(DT_LV)),Period,0,0),'convertfrom','datenum')];    
 
   clear Ta Period found_val indx SR SR_ND SS DL Temperature_Diff count DT_LV Tss
   
    end
 
DS_Temperature = interp1(DS_Temp_Time ,DS_Temperature , min(DS_Temp_Time):1/24:max(DS_Temp_Time))';
DS_Temp_Time = min(DS_Temp_Time):1/24:max(DS_Temp_Time);
 
clear P tc 
    
%% Relative Humidity (RH)
 
% Based on Modelling diurnal patterns of air temperature, radiation wind
% speed and relative humidity by equations from daily characteristics
% (J.E.Ephrath et al, 1996)
 
% Make Empty Arrays
DS_RH = [];
DS_RH_Time = [];
VPA_calc = [];
 
    for rhlv = 1:length(Daily_Time)
  
    TA = nanmean([Daily_Temp_Max(rhlv) Daily_Temp_Min(rhlv)]); % Get an aevrge temerpature
 
    RH = Daily_RelHum(rhlv); % Get Daily RH
    
    es = 6.107 * exp((TA * 17.4) /(239 + TA)); % saturated vapour pressure
    VPA = (((RH)*es)/(100));  % actual vapour pressure 
   
    clear TA
    
    TD_Array = -10:0.5:30; % Range of Dew Point Temperature
 
        for TD_Numerical = 1:length(TD_Array)
        Zero_array(TD_Numerical) = ( 6.107*exp((TD_Array(TD_Numerical) * 17.4) /(239 + TD_Array(TD_Numerical)))) - VPA;   % Numerical estimation of dew point temperature
        clear TD_Numerical
        end
 
    [~,Zero_Location] =  min(abs(Zero_array));  % Find closest dew point estimation to Zero 
 
    TD_est = TD_Array(Zero_Location);% get dew point estimation
    
    clear Zero_Location Zero_array TD_Array
 
    day_indx  = find(Daily_Time(rhlv) == datetime(year(DS_Temp_Time),month(DS_Temp_Time),day(DS_Temp_Time)));  % find correct downscaled temperature for relative humidity day
    
    VPA = 6.107 * exp((TD_est * 17.4) /(239 + TD_est));  % Recalculate actual vapour pressure 
    TD = DS_Temperature(day_indx); % Get daily downscaled daily temperature
    
    clear TD_Array TD_est
 
        for II = 1:length(day_indx)
        es = 6.107 * exp((TD(II) * 17.4) /(239 + TD(II))); % Recalculate saturated vapour pressure
        RH(II)  = VPA/es;   % Recalculate RH 
        clear es II
        end
        
    % Save variables
    DS_RH = [DS_RH RH];
    DS_RH_Time = [DS_RH_Time DS_Temp_Time(day_indx)];
    VPA_calc = [VPA_calc VPA'];
    
    clear total_RH RH day_indx TD VPA rhlv
 
    end
    
clear AirTempMax_Day AirTempMin_Day Obs_RelHum RelHum_Day Daily_Temp_Max Daily_Temp_Min Obs_Temper Daily_RelHum
 
 
%% Longwave 
 
% Comparison of algorithms for incoming atmospheric long-wave radiation (G.
% N. Flerchinge et al 2009)
 
% Make Empty Arrays
DS_Longwave = [];
 
    for lwlv = 1:length(Daily_Time)
        
    eclr = 0.83 - (0.18 * (10^(-0.067 * VPA_calc(lwlv)))); % angstrom 1918
    
    C_temp = Daily_Cloud(lwlv)/100; % get daily cloud cover (and turn it into a fraction)
    
    Ec = ((1 - (0.84*C_temp)) * eclr) + (0.84 * C_temp);% Clear-Sky Emissivity or Clear-Sky Long-Wave Radiation for Cloudy Days (Unsworth and Monteith)
    
    SBC = 5.670367 * 10^-8; % Stefan-Boltzmann constant
 
    day_indx  = find(Daily_Time(lwlv) == datetime(year(DS_Temp_Time),month(DS_Temp_Time),day(DS_Temp_Time))); % find corersponding days
 
    TD = DS_Temperature(day_indx);% Get downscaled temperature 
    
    clear TD_Array TD_est
 
        for II = 1:length(day_indx)
        LW(II) = Ec*SBC*((TD(II) + 273.15)^4);  % Calculate Long wave radiation
        clear II
        end
        
    DS_Longwave = [DS_Longwave LW];  % Add into total array
    
    clear LW TD
    
    end 
 
 
%% Wind Downscaling

% Based on A novel method to downscale daily wind statistics to hourly wind
% data for wind erosion modelling (Z Guo et al, 2015)
 
% Make Empty Arrays
DS_WD = [];
DS_WS = [];
DS_Wind_Time = [];
 
    for I = 1:length(Daily_Time) % Loop through Days
        
    U_DA = Daily_WindSpedU(I); % get U wind speed for day of interest  
    V_DA = Daily_WindSpedV(I); % get V wind speed for day of interest     
    
    count = 0; % Start count value 
 
        for II = 0:1:23 % loop through hours
        
        count = count + 1; % Increase count
    
        U(count)  = U_DA + (0.5*U_DA*cos((((II-WM)*pi)/12))); % Applies the sine wave around the U wind speed
        V(count)  = V_DA + (0.5*V_DA*cos((((II-WM)*pi)/12))) ;% Applies the sine wave around the V wind speed
        
        clear II
        end
        
    clear count
 
    wind_speed = sqrt((U.^2)+(V.^2)); % Create wind speed from U and V components 
    
    wind_angle = (atan2((U),(V)) * (180/pi)) + 180; % Creates meteorological wind direction
 
    clear US VS
        
    % Adds time and Value into series array    
    DS_WD = [DS_WD wind_angle];
    DS_WS = [DS_WS wind_speed];
    DS_Wind_Time = [DS_Wind_Time datetime(datenum(year(Daily_Time(I)),month(Daily_Time(I)),day(Daily_Time(I)),0:23,0,0),'convertfrom','datenum')];
 
    clear WS wind_angle wind_speed U_DA V_DA I
    end
 
clear Daily_WindSpedU Daily_WindSpedV total_WS total_Wind_Time total_WD u_Day v_Day Obs_wind_speed Obs_wind_dir
 
 
%% Pressure Downscaling
 
% Make Empty Arrays
DS_SP = [];
DS_SP_Time = [];
 
    for sp_lv = 1:length(Daily_Time) 
    DS_SP = [DS_SP repmat(Daily_SurPress(sp_lv),1,24)]; % Repeat the mean pressure over each hour step
    DS_SP_Time = [DS_SP_Time datetime(datenum(year(Daily_Time(sp_lv)),...
        month(Daily_Time(sp_lv)),day(Daily_Time(sp_lv)),0:23,0,0),'convertfrom','datenum')]; % Create and hourly 
    clear SP sp_lv
    end
 
clear Pressure_Day Obs_SurPress SPTIME Daily_SurPress SP_total
 
%% Raining Downscaling
 
% Make Empty Arrays
DS_Rain = [];
DS_Rain_Time = [];
 
    for rain_lv = 1:length(Daily_Time) 
    DS_Rain = [DS_Rain repmat(Daily_Rain(rain_lv),1,24)]; % Repeat the mean pressure over each hour step
    DS_Rain_Time = [DS_Rain_Time datetime(datenum(year(Daily_Time(rain_lv)),...
        month(Daily_Time(rain_lv)),day(Daily_Time(rain_lv)),0:23,0,0),'convertfrom','datenum')]; % Create and hourly 
    clear SP sp_lv
    end
 
clear Pressure_Day Obs_SurPress SPTIME Daily_SurPress SP_total

%% Sort Data on to same time step
 
clear Day_Array Daily_Time Uni_Days Lat Obs_Time Sunrise_Times_Leap Sunset_Times Sunset_Times_Leap Sunrise_Times
 
Min_Time = max([ min(DS_RH_Time) min(Ds_Solar_Time) min(DS_SP_Time) min(DS_Temp_Time) min(DS_Rain_Time) min(DS_Wind_Time)]); % Find the latest mimniuym time
 
Max_Time = min([max(DS_RH_Time) max(Ds_Solar_Time) max(DS_SP_Time) max(DS_Temp_Time) max(DS_Rain_Time) max(DS_Wind_Time)]); % Find the earliest maximum time
 
DS_Time_Array = (Min_Time:1/24:Max_Time); % Set an hourly time step
 
% Interpolate weather variables onto the shared time array
DS_RH = interp1(DS_RH_Time, DS_RH,DS_Time_Array);
DS_Solar = interp1(Ds_Solar_Time, DS_Solar,DS_Time_Array);
DS_SP = interp1(DS_SP_Time, DS_SP,DS_Time_Array);
DS_Temperature = interp1(DS_Temp_Time, DS_Temperature,DS_Time_Array);
DS_WD = interp1(DS_Wind_Time, DS_WD,DS_Time_Array);
DS_WS = interp1(DS_Wind_Time, DS_WS,DS_Time_Array);
DS_Longwave = interp1(DS_Temp_Time, DS_Longwave,DS_Time_Array);
DS_Rain = interp1(DS_Rain_Time, DS_Rain,DS_Time_Array);

% Find nans within arrays
remove = unique([find(isnan(DS_Longwave)==1) find(isnan(DS_RH)==1) find(isnan(DS_Solar)==1) find(isnan(DS_SP)==1)...
    find(isnan(DS_Temperature)==1) find(isnan(DS_WD)==1) find(isnan(DS_WS)==1) find(isnan(DS_Rain)==1) ]);
 
% Remove Nans
DS_RH(remove) = [];
DS_Solar(remove) = [];
DS_Temperature(remove) = [];
DS_SP(remove) = [];
DS_WD(remove) = [];
DS_WS(remove) = [];
DS_Longwave(remove) = [];
DS_Rain(remove) = [];
 
clear DS_CC_Time DS_RH_Time Ds_Solar_Time DS_SP_Time DS_Temp_Tim DS_Wind_Tim Max_Time Min_Time remove DS_Wind_Time DS_Temp_Time
 
end

