%%
clear;
d=190;
sigsum=dlmread([num2str(d),'km.txt']);
L=length(sigsum);
r=L/250004;
sigsum=reshape(sigsum,[250004,r]);
sigsum=sigsum';
%% calculate coherency for a certain distance
clearvars -except sigsum
[r,~]=size(sigsum);
st=1;
en=200000;
%% t-coh
filter_type='Butterworth zeropass';

Flo=[1 5 10e-3 150];
Fup=[400 15 2 400];
Order=[14 8 2 10];
fs=1e6;
X=-50:1e-3:150-1e-3;
figure(1);
for ty=1:4
    order=Order(ty);
    flo=(Flo(ty))*1e3;
    fup=(Fup(ty))*1e3;
    [q,w] = butter(order/2,[flo fup]/(fs/2),'bandpass');  
    for i=1:r
        b=sigsum(i,st:en);    
        b=filtfilt(q,w,b);     
        compb(i,:)=gtrace(b);
    end
    aa=compb./abs(compb);
    SIG(:,ty)=abs(mean(aa))';
    
    subplot(4,1,ty);
    plot(X,SIG(:,ty),'k');
    xlabel('[t]=ms');
    set(gca,'ylim',[0 1],'xlim',[-10 30]);
    set(gca,'FontSize',14);
end
saveas(figure(1),'Fig3','jpg');