clear;
coh=dlmread('Wavetable-coh-t.txt');
amp=dlmread('Wavetable-reim-amp.txt');
t=-1:1e-3:5-1e-5;

for num=1:70
    GG=1000;
    ran=[40 80 100 150 100];
    d=amp(num,6001);
    
    amp_sig=gfilter(amp(num,1:6000),1e6,1e3,400e3);
    amp_sig=gtrace(amp_sig);
    amp_sig=abs(amp_sig);
    coh_sig=coh(num,1:6000);

    for i=1:5
        sk(i)=skywround(d,90,i);
        skin(i)=round(sk(i),-1);
        [ma_coh(num,i),skcal(i)]=max(coh_sig(GG+skin(i)-ran(i):GG+skin(i)+ran(i)));
        skcal(i)=skcal(i)+GG+skin(i)-ran(i)-1;
        tdif(i)=skcal(i)-sk(i)-(GG);
    end
    [ma_coh(num,6),skcal(6)]=max(abs(coh_sig(GG:GG+30)));
    skcal(6)=skcal(6)+GG-1;
    ra_coh(num)=ma_coh(num,1)/ma_coh(num,6);
    tdif_coh(num,:)=tdif(:);
    ran=[40 80 100 150 100];
    for i=1:5
        sk(i)=skywround(d,90,i);
        skin(i)=skcal(i)-GG;
        [ma_amp(num,i),skcal(i)]=max(abs(amp_sig(GG+skin(i)-ran(i):GG+skin(i)+ran(i))));
        skcal(i)=skcal(i)+GG+skin(i)-ran(i)-1;
        tdif(i)=skcal(i)-sk(i)-(GG);
    end
    [ma_amp(num,6),skcal(6)]=max(abs(amp_sig(GG:GG+30)));
    skcal(6)=skcal(6)+GG-1;
    ra_amp(num)=ma_amp(num,1)/ma_amp(num,6);
    tdif_amp(num,:)=tdif(:);
end
A=[amp(:,6001),ma_amp,ma_coh];

figure(1);
D=amp(:,6001);
scatter(D,1./ra_amp,'r');
hold on;
scatter(D,1./ra_coh,'k');
set(gca,'fontsize',14);
xlabel('[d] = km');
ylabel( '[Ground wave / 1st Skywave]')
set(gca,'xlim',[D(1) D(70)]);
box on;
saveas(figure(1),'Fig6a','jpg');