clear;
sigsum=dlmread('impulse_detection_cases.txt');
stawave=dlmread('Wavetable-reim-amp.txt');
dis=stawave(:,6001);



figure(1);
flo=1000;
fup=50000;
d=sigsum(3,6002);
load './la4t.mat';
im=[zeros(1,1000),1,zeros(1,4999)];
xx=(-1000:1:4999)/1000;
[li,no]=ismember(d,dis);
sig=stawave(no,1:6000);
sig=sig./(max(sig(1000:1030)));
IR=fft(im)./fft(sig);
re_sig=sigsum(3,1:6000);
I=sigsum(3,6001);
re_sig=ifft(fft(re_sig).*yt');
re_sig=re_sig./max(re_sig(1000:1030));

plot(xx,re_sig,'k','LineWidth',4);
ylabel('[y_{m}] = V/m');

set(gca,'xlim',[-0.1,0.1],'ylim',[-0.6,1.2]);
xlabel('[t] = ms');
set(gca,'fontsize',14,'Linewidth',4);
set(gca,'FontWeight','bold')
saveas(gca,'Fig4c_zoom.jpg');

