clear;
sta=4;
sigsum=dlmread('Wavetable-reim-amp.txt');
[row,~]=size(sigsum);
dis=sigsum(:,6001);

%% amplitude waveform bank time range figure
x=-1:1e-3:5-1e-3;
figure(1);
for i=1:length(dis)
    y=sigsum(i,6001).*ones(1,6000);
    sig=sigsum(i,1:6000);
    sig=gfilter(sig,1e6,1e3,400e3);
    y=y+sig*100;
    xx=[x' x'];
    yy=[y' y'];
    z=sig;
    
    z1=zeros(size(xx));
    zc=[z' z'];
    hs=surf(xx,yy,z1,zc,'EdgeColor','interp');
    colormap(turbo);
    view(2)
    hold on
end
xlabel('[t] = ms')
ylabel('[d] = km');
hc = colorbar;
hc.Label.String = '[A]=V/m';
hc.Label.FontSize=14;
box on;
set(gca,'fontsize',14);
saveas(figure(1),'Fig2a','jpg');
%% amplitude waveform bank spectrum figure
dima=max(dis);
dimi=min(dis);
R=(dima-dimi)/10+1;
SIG=zeros(R,6001);
SIG(:,6001)=dimi:10:dima;
for i=1:row
    for j=1:R
        if sigsum(i,6001)==SIG(j,6001)
            SIG(j,:)=sigsum(i,:);
        end
    end
end

for i=1:R
    [XF(i,:),YF(i,:)]=spct(SIG(i,1:6000));
end
CF=YF(:,1:1800);
figure(2);
fre=mean(XF);
xf=[0 300];
y=[dimi dima];
lim=[-4.5,-1];
imagesc(xf,y,CF,lim);
set(gca,'YDir','normal','fontsize',14);
colormap(turbo);
colorbar;
xlabel('[f] = kHz')
ylabel('[d] = km');
hc = colorbar;
hc.Label.String = 'log10([A]=V/m)';
hc.Label.FontSize=14;

box on;
set(gca,'fontsize',14);
set(gca,'ylim',[0,1400]);
saveas(figure(2),'Fig2b','jpg');