clear

sigsum=dlmread('Wavetable-coh-t.txt');
[row,~]=size(sigsum);
dis=sigsum(:,6001);

%% coherency waveform bank time range figure

x=-1:1e-3:5-1e-3;
figure(1);
for i=1:length(dis)
    y=sigsum(i,6001).*ones(1,6000);
    sig=sigsum(i,1:6000);
    y=y+sig*100;
    xx=[x' x'];
    yy=[y' y'];
    z=sig;
    
    z1=zeros(size(xx));
    zc=[z' z'];
    hs=surf(xx,yy,z1,zc,'EdgeColor','interp');
    colormap(turbo);
    view(2);
    hold on
end
xlabel('[t] = ms');
ylabel('[d] = km');
hc = colorbar;
hc.Label.String = '[coh]';
hc.Label.FontSize=14;
box on;
set(gca,'fontsize',14);
saveas(figure(1),'Fig2c','jpg');
%% coherency waveform bank spectrum figure
figure(2);
Y=dlmread('Wavetable-coh-f.txt');
r=length(dis);
YY=zeros((dis(r)-dis(1))/10+1,3000);

DD=dis(1):10:dis(r);
YY=[YY,DD'];
for i=1:r
    for j=1:length(DD)
        if Y(i,3001)==YY(j,3001)
            YY(j,:)=Y(i,:);
        end
    end
end
x=[0 500];
z=[dis(1) dis(r)];
lim=[0 1];
imagesc(x,z,YY,lim);
set(gca,'YDir','normal','fontsize',14);
colormap(turbo);
colorbar;
xlabel('[f] = kHz')
ylabel('[d] = km');
set(gca,'xlim',[0,300])
hc = colorbar;
hc.Label.String = '[coh]';
hc.Label.FontSize=14;
box on;
set(gca,'fontsize',14);
set(gca,'ylim',[0,1400]);
saveas(figure(2),'Fig2d','jpg');