clear;
sigsum=dlmread('impulse_detection_cases.txt');
stawave=dlmread('Wavetable-reim-amp.txt');
dis=stawave(:,6001);


for i=1:4
    flo=1000;
    fup=50000;
    d=sigsum(i,6002);
    load './la4t.mat';
    im=[zeros(1,1000),1,zeros(1,4999)];
    xx=(-1000:1:4999)/1000;
    [li,no]=ismember(d,dis);
    sig=stawave(no,1:6000);
    sig=sig./(max(sig(1000:1030)));
    IR=fft(im)./fft(sig);
    re_sig=sigsum(i,1:6000);
    I=sigsum(i,6001);
    re_sig=ifft(fft(re_sig).*yt');
    re_sig=re_sig./max(re_sig(1000:1030));

    hh=figure(i);
    a=subplot(3,1,1);
    plot(xx,sig,'k');

    ylabel('[y_d] = V/m');
    set(gca,'XTick',[]);
    set(gca,'xlim',[-1,5]);

    b=subplot(3,1,2);
    plot(xx,re_sig,'k');
    ylabel('[y_{m}] = V/m');
    set(gca,'XTick',[]);
    set(gca,'xlim',[-1,5]);
    hold on;
    

    if i==3
        square_xx=[-0.1,-0.1,0.1,0.1,-0.1];
        square_yy=[-0.6,1.2,1.2,-0.6,-0.6];
        plot(square_xx,square_yy,'r');
    end
    re_cal=ifft(fft(re_sig).*IR);
    re_cal=gfilter(re_cal,1e6,flo,fup);

    c=subplot(3,1,3);
    plot(xx,re_cal,'k');
    hold on;
    xlabel('[t] = ms');
    ylabel('[y_{out}] = V/m');


    [impma,loc,ra,thr]=impdetect(re_cal);
    yythr=thr.*ones(1,6000);
    plot(xx,yythr,'r');
    hold off;
    set(gca,'xlim',[-1,5]);

    h(1,:)=get(a,'Position');
    h(2,:)=get(b,'Position');
    h(3,:)=get(c,'Position');
    move=0.05;
    set(a,'Position',[h(1,1) h(1,2)-move h(1,3) h(1,4)]);
    set(b,'Position',[h(1,1) h(2,2) h(1,3) h(1,4)]);
    set(c,'Position',[h(1,1) h(3,2)+move h(1,3) h(1,4)]);
    set(a,'fontsize',14);
    set(b,'fontsize',14);
    set(c,'fontsize',14);
    saveas(figure(i),['Fig4-',num2str(i)],'jpg');
end
