clear;
coh=dlmread('Wavetable-coh-t.txt');
amp=dlmread('Wavetable-reim-amp.txt');
t=-1:1e-3:5-1e-5;
%% take 1210km waveforms
for num=69
    GG=1000;
    ran=[20 20 20 20 50 40 80 20];
    d=amp(num,6001);
    
    amp_sig=gfilter(amp(num,1:6000),1e6,1e3,400e3);
    amp_sig=gtrace(amp_sig);
    amp_sig=log10(abs(amp_sig));
    figure(1);
    coh_sig=log10(coh(num,1:6000));
    b=subplot(2,1,2);
    plot(t,coh_sig,'k','LineWidth',1);
    hold on;
    for i=1:8
        sk(i)=skywround(d,90,i);
        skin(i)=round(sk(i),-1);
        [ma_coh(num,i),skcal(i)]=max(coh_sig(GG+skin(i)-ran(i):GG+skin(i)+ran(i)));
        skcal(i)=skcal(i)+GG+skin(i)-ran(i)-1;
        tdif(i)=skcal(i)-sk(i)-(GG);        
        scatter(t(skcal(i)),ma_coh(num,i),'r','filled');
        hold on;
        
    end
    [ma_coh(num,100),skcal(100)]=max(coh_sig(GG:GG+30));
    skcal(100)=skcal(100)+GG-1;
    scatter(t(skcal(100)),coh_sig(skcal(100)),'k','filled');
    hold on;
    
    ra_coh(num)=ma_coh(num,1)/ma_coh(num,100);
    tdif_coh(num,:)=tdif(:);
    xlabel('[t]=ms');
    ylabel('log10([coh])');
    
    a=subplot(2,1,1);
    plot(t,amp_sig,'k','LineWidth',1);
    hold on;
    for i=1:8
        sk(i)=skywround(d,90,i);
        skin(i)=skcal(i)-GG;
        [ma_amp(num,i),skcal(i)]=max(amp_sig(GG+skin(i)-ran(i):GG+skin(i)+ran(i)));
        skcal(i)=skcal(i)+GG+skin(i)-ran(i)-1;
        tdif(i)=skcal(i)-sk(i)-(GG);
        
        
        scatter(t(skcal(i)),amp_sig(skcal(i)),'r','filled');
        hold on;
        
    end
    [ma_amp(num,100),skcal(100)]=max(amp_sig(GG:GG+30));
    skcal(100)=skcal(100)+GG-1;
    
    scatter(t(skcal(100)),amp_sig(skcal(100)),'k','filled');
    hold on;
    
    ra_amp(num)=ma_amp(num,1)/ma_amp(num,100);
    tdif_amp(num,:)=tdif(:);
    hold off;
    set(gca,'XTick',[]);
    ylabel('log10([|A|] = V/m)');
    
    
    h(1,:)=get(a,'Position');
    h(2,:)=get(b,'Position');
    
    move=0.05;
    set(a,'Position',[h(1,1) h(1,2)-move h(1,3) h(1,4)]);
    set(b,'Position',[h(1,1) h(2,2)+move h(1,3) h(1,4)]);
    
    set(a,'fontsize',14);
    set(b,'fontsize',14);
    box on;
    hold off;
end
saveas(figure(1),'Fig5b','jpg');