clear;
dis=dlmread('Disbin.txt');
time_amp=dlmread('ampskywtime.txt');
time_coh=dlmread('cohskywtime.txt');

for i=1:5
    weight=0.31.^(i-1);
end
dlmwrite('weight.txt',weight,'precision',64);

for i=1:70
    d=dis(i);
    skwt=[time_amp(i,:),d];
    dlmwrite('skytime.txt',skwt,'precision',64);
    h0=90;
    h_amp(i)=fminsearch(@timedelay,h0);
end

for i=1:5
    weight=1;
end
dlmwrite('weight.txt',weight,'precision',64);

for i=1:70
    d=dis(i);
    skwt=[time_coh(i,:),d];
    dlmwrite('skytime.txt',skwt,'precision',64);
    h0=90;
    h_coh(i)=fminsearch(@timedelay,h0);
end

figure(1);
a=scatter(dis,h_amp,'r');
hold on
b=scatter(dis,h_coh,'k');
xlabel('[ d ] = km');
ylabel('[ h ] = km');
set(gca,'fontsize',14);
set(gca,'xlim',[dis(1) dis(70)]);
box on;
saveas(figure(1),'Fig6b','jpg');