% complex trace 
% Taner, Koehler and Sheriff, Gephysics 44(6), 1041, 1979
% [yc]=gtrace(y)
% input:  
% y      - time series
% output: 
% yc     - complex trace 
function [yc]=gtrace(y)
n=length(y);                                  % samples, time interval
yf=fft(y);                                    % spectrum 
yf(n/2+2:n)=0;                                % zero neg freq
yf(2:n/2)=yf(2:n/2)*2;                        % double spectrum
yc=ifft(yf);                                  % complex trace                                
return;                                       % end complex trace