# README

## Title

  Dataset for
  ``Novel super-reduced, pedagogical model for scoping net zero buildings''


## Abstract

The dataset corresponds to (1) the ZEBRA tool, (2) its validation and (3) built-in examples.
The ZEBRA tool is a novel, super-reduced, pedagogical model for scoping net zero buildings.
The validation is after ASHRAE Standard 140-2017
for space heating demand intensity after HERS BESTEST (Judkoff & Neymark 1995).
The built-in examples are domestic buildings located in the UK and are
described in the PDF files and implemented in ZEBRA.


## Description

ZEBRA is a model for scoping net zero buildings (energy and/or carbon).
It focuses on a first-principles, transparent approach to building physics and sustainability.
The tool is meant to be used at very early design stage, to influence fundamental design decisions.
Its scope is operational energy use (life cycle stage B6, EN 15978:2011)
and upfront embodied carbon (life cycle stages A1-A5),
although the commentary targets whole-life carbon.

The validation after HERS Bestest contains a base model for a single zone,
single storey building isolated in Colorado (USA).
This base model (ID L100A) is then modified in a series of scenarios
targetting different building properties, like glazing ratios, insulation levels,
or shading conditions (IDs L110A to L324A and P110A to P150A).

The examples are domestic buildings in the UK built with a desire to deliver
a space heating demand better than the average of the national stock.
These houses are described with the information that would be typically available
early in the design process,
following a first sketch of solutions that is meant to be influenced with ZEBRA.

This research was funded by the Engineering and Physical Sciences Research Council (EPSRC),
project “The Active Building Centre Research Programme” [EP/V012053/1].


## License

Different licenses apply to different files in this dataset.
CSV, MD and PDF files are licensed as CC BY-SA 4.0.
XLSX files are licensed as GNU GPL
(see notice below and full license terms within the LICENSE sheet within each file).

This dataset contains free software:
you can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.
The dataset is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
A copy of the GNU General Public License is included within each spreadsheet,
and is available from <https://www.gnu.org/licenses/>.


## Data

The data is stored in plain-text files (either CSV or MD files, encoded in UTF-8)
and spreadsheets (xlsx, Microsoft Excel 365, Version 2107 Build 14228.20226).

.
├── README.md                   # This file
├── zebra-v21_07_12-blank.xlsx  # Blank copy of ZEBRA (Excel / LibreOffice)
├── examples                    # Examples with description (pdf) and solutions (xlsx).
│   ├── zebra-v21_07_12-example-detached.pdf
│   ├── zebra-v21_07_12-example-detached.xlsx
│   ├── zebra-v21_07_12-example-mid-terrace.pdf
│   └── zebra-v21_07_12-example-mid-terrace.xlsx
└── validation                                         # Validation suite
    ├── zebra-v21_07_12-validation-bestest.csv         # Overview in CSV file.
    ├── zebra-v21_07_12-validation-bestest.md          # Overview in Markdown file.
    ├── zebra-v21_07_12-validation-bestest-L100A.xlsx  # Test L100A
    ├── zebra-v21_07_12-validation-bestest-L110A.xlsx  # Test L110A
    ├── zebra-v21_07_12-validation-bestest-L120A.xlsx  # Test L120A
    ├── zebra-v21_07_12-validation-bestest-L130A.xlsx  # Test L130A
    ├── zebra-v21_07_12-validation-bestest-L140A.xlsx  # Test L140A
    ├── zebra-v21_07_12-validation-bestest-L150A.xlsx  # Test L150A
    ├── zebra-v21_07_12-validation-bestest-L155A.xlsx  # Test L155A
    ├── zebra-v21_07_12-validation-bestest-L160A.xlsx  # Test L160A
    ├── zebra-v21_07_12-validation-bestest-L165A.xlsx  # Test L165A
    ├── zebra-v21_07_12-validation-bestest-L170A.xlsx  # Test L170A
    ├── zebra-v21_07_12-validation-bestest-L200A.xlsx  # Test L200A
    ├── zebra-v21_07_12-validation-bestest-L202A.xlsx  # Test L202A
    ├── zebra-v21_07_12-validation-bestest-L302A.xlsx  # Test L302A
    ├── zebra-v21_07_12-validation-bestest-L304A.xlsx  # Test L304A
    ├── zebra-v21_07_12-validation-bestest-L322A.xlsx  # Test L322A
    ├── zebra-v21_07_12-validation-bestest-L324A.xlsx  # Test L324A
    ├── zebra-v21_07_12-validation-bestest-P100A.xlsx  # Test P100A
    ├── zebra-v21_07_12-validation-bestest-P105A.xlsx  # Test P105A
    ├── zebra-v21_07_12-validation-bestest-P110A.xlsx  # Test P110A
    ├── zebra-v21_07_12-validation-bestest-P140A.xlsx  # Test P140A
    └── zebra-v21_07_12-validation-bestest-P150A.xlsx  # Test P150A


# References

* American National Standards Institute &
  American Society of Heating Refrigerating and Air-Conditioning, 2017.
  Standard 140-2017: Standard Method of Test for the Evaluation of
  Building Energy Analysis Computer Programs,
  Atlanta: American Society of Heating Refrigerating and Air-Conditioning.

* British Standards Institution, 2011.
  BS EN 15978:2011: Sustainability of construction works —
  Assessment of environmental performance of buildings — Calculation method,
  London: British Standards Institution.

* Judkoff, R. & Neymark, J., 1995.
  Home Energy Rating System Building Energy Simulation Test (HERS BESTEST):
  Volume 1; Tier 1 and Tier 2 Tests; User’s Manual,
  Golden, Colorado: National Renewable Energy Laboratory.
