# Use setwd()to specify the path to the 'Active Buildings' folder
getwd()

library(lme4)

# EXISTING REGULATIONS Read in the data
reg <- read.csv("ExistingRegulations.csv", header = TRUE)
reg$Criterion <- as.factor(reg$Criterion)
reg$Group <- as.factor(reg$Group)
reg$Response <- as.factor(reg$Response)

# Regression model
gmreg <- glm(Response ~ Criterion * Group, family = "binomial", data = reg)
print(summary(gmreg))
gmreg$coefficients
exp(gmreg$coefficients)

# DEFINITION Read in the data
reg <- read.csv("Definition.csv", header = TRUE)
reg$Criterion <- as.factor(reg$Criterion)
reg$Group <- as.factor(reg$Group)
reg$Response <- as.factor(reg$Response)

# Regression model
gmreg <- glm(Response ~ Criterion * Group, family = "binomial", data = reg)
print(summary(gmreg))
gmreg$coefficients
exp(gmreg$coefficients)

# PERFORMANCE ASSESSMENT Read in the data
reg <- read.csv("PerformanceAssessment.csv", header = TRUE)
reg$Criterion <- as.factor(reg$Criterion)
reg$Group <- as.factor(reg$Group)
reg$Response <- as.factor(reg$Response)

# Regression model (interaction not significant)
gmreg <- glm(Response ~ Criterion + Group, family = "binomial", data = reg)
print(summary(gmreg))
gmreg$coefficients
exp(gmreg$coefficients)

# CHALLENGES Read in the data
reg <- read.csv("Challenges.csv", header = TRUE)
reg$Criterion <- as.factor(reg$Criterion)
reg$Group <- as.factor(reg$Group)
reg$Response <- as.factor(reg$Response)

# Regression model
gmreg <- glm(Response ~ Criterion * Group, family = "binomial", data = reg)
print(summary(gmreg))
gmreg$coefficients
exp(gmreg$coefficients)