
# EDA CT Scale ------------------------------------------------------------
# Here we produce some ismple plots of the census tract level data, the crimes against the socio-economic variables as well as some histograms for the socio-economic variables at the census tract-level.
# Note that the only socio-economic variables used within my thesis were the total population and average income and so the final R code for data generation was tailored accordingly, with the code for the inclusion of other socio-economic variables commented out and we do the same below. For any additional variables we comment out they're inclusion and plot outputs and this can be easily uncommented if required to generate the relevant plots.

# Author: Nadeen Khaleel


# Set WD and Load Libraries -----------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(ggplot2)
library(gridExtra)


# Los Angeles -------------------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))
# Then as we want to store the results in the LA directory, also run
setwd("./LA")
load("../../PROCESSED_DATA/CRIME/COUNT_DATA_CENSUS_TRACTS/LA/LA2015CTCountData_projFinal.rda")

# Homicide

hompop <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=pop)) + xlab("Homicide") + ylab("Population") + ggtitle("Incidence of Homicide in LA against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
hominc <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=inc)) + xlab("Homicide") + ylab("Average Income") + ggtitle("Incidence of Homicide in LA against Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# hommsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=msex)) + xlab("Homicide") + ylab("Proportion Male") + ggtitle("Incidence of Homicide in LA against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=fsex)) + xlab("Homicide") + ylab("Proportion Female") + ggtitle("Incidence of Homicide in LA against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homown <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=own)) + xlab("Homicide") + ylab("Proportion Own") + ggtitle("Incidence of Homicide in LA against Proportion Owned\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homrent <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=rent)) + xlab("Homicide") + ylab("Proportion Rent") + ggtitle("Incidence of Homicide in LA against Proportion Rented\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfood <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=food)) + xlab("Homicide") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Homicide in LA against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "LAHomvPopCT.pdf",plot=hompop, height = 7.5, width=10)
ggsave(filename = "LAHomvImpIncCT.pdf",plot=hominc, height = 7.5, width=10)
# ggsave(filename = "LAHomvSexMCT.pdf",plot=hommsex, height = 7.5, width=10)
# ggsave(filename = "LAHomvSexFCT.pdf",plot=homfsex, height = 7.5, width=10)
# ggsave(filename = "LAHomvOccOwnCT.pdf",plot=homown, height = 7.5, width=10)
# ggsave(filename = "LAHomvOccRentCT.pdf",plot=homrent, height = 7.5, width=10)
# ggsave(filename = "LAHomvFoodCT.pdf",plot=homfood, height = 7.5, width=10)

# GTA

gtapop <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=pop)) + xlab("Motor Vehicle Theft") + ylab("Population") + ggtitle("Incidence of Motor Vehicle Theft in LA against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
gtainc <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=inc)) + xlab("Motor Vehicle Theft") + ylab("Average Income") + ggtitle("Incidence of Motor Vehicle Theft in LA against Average\n Income on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtamsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=msex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Male") + ggtitle("Incidence of Motor Vehicle Theft in LA against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=fsex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Female") + ggtitle("Incidence of Motor Vehicle Theft in LA against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtaown <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=own)) + xlab("Motor Vehicle Theft") + ylab("Proportion Own") + ggtitle("Incidence of Motor Vehicle Theft against in LA Proportion\n Owned Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtarent <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=rent)) + xlab("Motor Vehicle Theft") + ylab("Proportion Rent") + ggtitle("Incidence of Motor Vehicle Theft against in LA Proportion\n Rented Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafood <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=food)) + xlab("Motor Vehicle Theft") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Motor Vehicle Theft in LA against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "LAGTAvPopCT.pdf",plot=gtapop, height = 7.5, width=10)
ggsave(filename = "LAGTAvImpIncCT.pdf",plot=gtainc, height = 7.5, width=10)
# ggsave(filename = "LAGTAvSexMCT.pdf",plot=gtamsex, height = 7.5, width=10)
# ggsave(filename = "LAGTAvSexFCT.pdf",plot=gtafsex, height = 7.5, width=10)
# ggsave(filename = "LAGTAvOccOwnCT.pdf",plot=gtaown, height = 7.5, width=10)
# ggsave(filename = "LAGTAvOccRentCT.pdf",plot=gtarent, height = 7.5, width=10)
# ggsave(filename = "LAGTAvFoodCT.pdf",plot=gtafood, height = 7.5, width=10)

# Histograms
lapop <- ggplot(ct_homcount.df) + geom_histogram(aes(pop)) + ylab("Population") + ggtitle("Histogram of LA Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
lainc <- ggplot(ct_homcount.df) + geom_histogram(aes(inc)) + ylab("Average Income") + ggtitle("Histogram of LA Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# lamsex <- ggplot(ct_homcount.df) + geom_histogram(aes(msex)) + ylab("Proportion Male") + ggtitle("Histogram of LA Proportion Male\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# lafsex <- ggplot(ct_homcount.df) + geom_histogram(aes(fsex)) + ylab("Proportion Female") + ggtitle("Histogram of LA Proportion Femail\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# laown <- ggplot(ct_homcount.df) + geom_histogram(aes(own)) + ylab("Proportion Own") + ggtitle("Histogram of LA Proportion Owned Properties \n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# larent <- ggplot(ct_homcount.df) + geom_histogram(aes(rent)) + ylab("Proportion Rent") + ggtitle("Histogram of LA Proportion Rented Properties\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# lafood <- ggplot(ct_homcount.df) + geom_histogram(aes(food)) + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Histogram of LA Percentage Houses\n Receiving Food Stamps\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "LAPopHistCT.pdf",plot=lapop, height = 7.5, width=10)
ggsave(filename = "LAImpIncHistCT.pdf",plot=lainc, height = 7.5, width=10)
# ggsave(filename = "LASexMHistCT.pdf",plot=lamsex, height = 7.5, width=10)
# ggsave(filename = "LASexFHistCT.pdf",plot=lafsex, height = 7.5, width=10)
# ggsave(filename = "LAOccOwnHistCT.pdf",plot=laown, height = 7.5, width=10)
# ggsave(filename = "LAOccRentHistCT.pdf",plot=larent, height = 7.5, width=10)
# ggsave(filename = "LAFoodHistCT.pdf",plot=lafood, height = 7.5, width=10)


# New York ----------------------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))
# Then as we want to store the results in the NYC directory, also run
setwd("./NYC")
load("../../PROCESSED_DATA/CRIME/COUNT_DATA_CENSUS_TRACTS/NYC/NY2015CTCountData_projFinal.rda")

# Homicide

hompop <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=pop)) + xlab("Homicide") + ylab("Population") + ggtitle("Incidence of Homicide in NY against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
hominc <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=inc)) + xlab("Homicide") + ylab("Average Income") + ggtitle("Incidence of Homicide in NY against Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# hommsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=msex)) + xlab("Homicide") + ylab("Proportion Male") + ggtitle("Incidence of Homicide in NY against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=fsex)) + xlab("Homicide") + ylab("Proportion Female") + ggtitle("Incidence of Homicide in NY against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homown <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=own)) + xlab("Homicide") + ylab("Proportion Own") + ggtitle("Incidence of Homicide in NY against Proportion Owned\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homrent <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=rent)) + xlab("Homicide") + ylab("Proportion Rent") + ggtitle("Incidence of Homicide in NY against Proportion Rented\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfood <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=food)) + xlab("Homicide") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Homicide in NY against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "NYHomvPopCT.pdf",plot=hompop, height = 7.5, width=10)
ggsave(filename = "NYHomvImpIncCT.pdf",plot=hominc, height = 7.5, width=10)
# ggsave(filename = "NYHomvSexMCT.pdf",plot=hommsex, height = 7.5, width=10)
# ggsave(filename = "NYHomvSexFCT.pdf",plot=homfsex, height = 7.5, width=10)
# ggsave(filename = "NYHomvOccOwnCT.pdf",plot=homown, height = 7.5, width=10)
# ggsave(filename = "NYHomvOccRentCT.pdf",plot=homrent, height = 7.5, width=10)
# ggsave(filename = "NYHomvFoodCT.pdf",plot=homfood, height = 7.5, width=10)

# GTA

gtapop <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=pop)) + xlab("Motor Vehicle Theft") + ylab("Population") + ggtitle("Incidence of Motor Vehicle Theft in NY against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
gtainc <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=inc)) + xlab("Motor Vehicle Theft") + ylab("Average Income") + ggtitle("Incidence of Motor Vehicle Theft in NY against Average\n Income on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtamsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=msex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Male") + ggtitle("Incidence of Motor Vehicle Theft in NY against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=fsex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Female") + ggtitle("Incidence of Motor Vehicle Theft in NY against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtaown <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=own)) + xlab("Motor Vehicle Theft") + ylab("Proportion Own") + ggtitle("Incidence of Motor Vehicle Theft against in NY Proportion\n Owned Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtarent <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=rent)) + xlab("Motor Vehicle Theft") + ylab("Proportion Rent") + ggtitle("Incidence of Motor Vehicle Theft against in NY Proportion\n Rented Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafood <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=food)) + xlab("Motor Vehicle Theft") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Motor Vehicle Theft in NY against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "NYGTAvPopCT.pdf",plot=gtapop, height = 7.5, width=10)
ggsave(filename = "NYGTAvImpIncCT.pdf",plot=gtainc, height = 7.5, width=10)
# ggsave(filename = "NYGTAvSexMCT.pdf",plot=gtamsex, height = 7.5, width=10)
# ggsave(filename = "NYGTAvSexFCT.pdf",plot=gtafsex, height = 7.5, width=10)
# ggsave(filename = "NYGTAvOccOwnCT.pdf",plot=gtaown, height = 7.5, width=10)
# ggsave(filename = "NYGTAvOccRentCT.pdf",plot=gtarent, height = 7.5, width=10)
# ggsave(filename = "NYGTAvFoodCT.pdf",plot=gtafood, height = 7.5, width=10)


# Histograms
nypop <- ggplot(ct_homcount.df) + geom_histogram(aes(pop)) + ylab("Population") + ggtitle("Histogram of NY Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
nyinc <- ggplot(ct_homcount.df) + geom_histogram(aes(inc)) + ylab("Average Income") + ggtitle("Histogram of NY Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# nymsex <- ggplot(ct_homcount.df) + geom_histogram(aes(msex)) + ylab("Proportion Male") + ggtitle("Histogram of NY Proportion Male\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# nyfsex <- ggplot(ct_homcount.df) + geom_histogram(aes(fsex)) + ylab("Proportion Female") + ggtitle("Histogram of NY Proportion Femail\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# nyown <- ggplot(ct_homcount.df) + geom_histogram(aes(own)) + ylab("Proportion Own") + ggtitle("Histogram of NY Proportion Owned Properties \n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# nyrent <- ggplot(ct_homcount.df) + geom_histogram(aes(rent)) + ylab("Proportion Rent") + ggtitle("Histogram of NY Proportion Rented Properties\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# nyfood <- ggplot(ct_homcount.df) + geom_histogram(aes(food)) + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Histogram of NY Percentage Houses\n Receiving Food Stamps\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "NYPopHistCT.pdf",plot=nypop, height = 7.5, width=10)
ggsave(filename = "NYImpIncHistCT.pdf",plot=nyinc, height = 7.5, width=10)
# ggsave(filename = "NYSexMHistCT.pdf",plot=nymsex, height = 7.5, width=10)
# ggsave(filename = "NYSexFHistCT.pdf",plot=nyfsex, height = 7.5, width=10)
# ggsave(filename = "NYOccOwnHistCT.pdf",plot=nyown, height = 7.5, width=10)
# ggsave(filename = "NYOccRentHistCT.pdf",plot=nyrent, height = 7.5, width=10)
# ggsave(filename = "NYFoodHistCT.pdf",plot=nyfood, height = 7.5, width=10)


# Portland ----------------------------------------------------------------



# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))
# Then as we want to store the results in the Portland directory, also run
setwd("./Portland")
load("../../PROCESSED_DATA/CRIME/COUNT_DATA_CENSUS_TRACTS/Portland/P2015CTCountData_projFinal.rda")

# Homicide

hompop <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=pop)) + xlab("Homicide") + ylab("Population") + ggtitle("Incidence of Homicide in Portland against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
hominc <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=inc)) + xlab("Homicide") + ylab("Average Income") + ggtitle("Incidence of Homicide in Portland against Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# hommsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=msex)) + xlab("Homicide") + ylab("Proportion Male") + ggtitle("Incidence of Homicide in Portland against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfsex <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=fsex)) + xlab("Homicide") + ylab("Proportion Female") + ggtitle("Incidence of Homicide in Portland against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homown <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=own)) + xlab("Homicide") + ylab("Proportion Own") + ggtitle("Incidence of Homicide in Portland against Proportion Owned\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homrent <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=rent)) + xlab("Homicide") + ylab("Proportion Rent") + ggtitle("Incidence of Homicide in Portland against Proportion Rented\n Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# homfood <- ggplot(ct_homcount.df) + geom_point(aes(x=hom,y=food)) + xlab("Homicide") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Homicide in Portland against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "PHomvPopCT.pdf",plot=hompop, height = 7.5, width=10)
ggsave(filename = "PHomvImpIncCT.pdf",plot=hominc, height = 7.5, width=10)
# ggsave(filename = "PHomvSexMCT.pdf",plot=hommsex, height = 7.5, width=10)
# ggsave(filename = "PHomvSexFCT.pdf",plot=homfsex, height = 7.5, width=10)
# ggsave(filename = "PHomvOccOwnCT.pdf",plot=homown, height = 7.5, width=10)
# ggsave(filename = "PHomvOccRentCT.pdf",plot=homrent, height = 7.5, width=10)
# ggsave(filename = "PHomvFoodCT.pdf",plot=homfood, height = 7.5, width=10)

# GTA

gtapop <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=pop)) + xlab("Motor Vehicle Theft") + ylab("Population") + ggtitle("Incidence of Motor Vehicle Theft in Portland against Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
gtainc <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=inc)) + xlab("Motor Vehicle Theft") + ylab("Average Income") + ggtitle("Incidence of Motor Vehicle Theft in Portland against Average\n Income on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtamsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=msex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Male") + ggtitle("Incidence of Motor Vehicle Theft in Portland against Proportion\n Male on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafsex <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=fsex)) + xlab("Motor Vehicle Theft") + ylab("Proportion Female") + ggtitle("Incidence of Motor Vehicle Theft in Portland against Proportion\n Female on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtaown <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=own)) + xlab("Motor Vehicle Theft") + ylab("Proportion Own") + ggtitle("Incidence of Motor Vehicle Theft against in Portland Proportion\n Owned Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtarent <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=rent)) + xlab("Motor Vehicle Theft") + ylab("Proportion Rent") + ggtitle("Incidence of Motor Vehicle Theft against in Portland Proportion\n Rented Properties on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# gtafood <- ggplot(ct_gtacount.df) + geom_point(aes(x=gta,y=food)) + xlab("Motor Vehicle Theft") + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Incidence of Motor Vehicle Theft in Portland against Percentage Houses\n Receiving Food Stamps on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "PGTAvPopCT.pdf",plot=gtapop, height = 7.5, width=10)
ggsave(filename = "PGTAvImpIncCT.pdf",plot=gtainc, height = 7.5, width=10)
# ggsave(filename = "PGTAvSexMCT.pdf",plot=gtamsex, height = 7.5, width=10)
# ggsave(filename = "PGTAvSexFCT.pdf",plot=gtafsex, height = 7.5, width=10)
# ggsave(filename = "PGTAvOccOwnCT.pdf",plot=gtaown, height = 7.5, width=10)
# ggsave(filename = "PGTAvOccRentCT.pdf",plot=gtarent, height = 7.5, width=10)
# ggsave(filename = "PGTAvFoodCT.pdf",plot=gtafood, height = 7.5, width=10)


# Histograms
ppop <- ggplot(ct_homcount.df) + geom_histogram(aes(pop)) + ylab("Population") + ggtitle("Histogram of Portland Population\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
pinc <- ggplot(ct_homcount.df) + geom_histogram(aes(inc)) + ylab("Average Income") + ggtitle("Histogram of Portland Average Income\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# pmsex <- ggplot(ct_homcount.df) + geom_histogram(aes(msex)) + ylab("Proportion Male") + ggtitle("Histogram of Portland Proportion Male\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# pfsex <- ggplot(ct_homcount.df) + geom_histogram(aes(fsex)) + ylab("Proportion Female") + ggtitle("Histogram of Portland Proportion Femail\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# pown <- ggplot(ct_homcount.df) + geom_histogram(aes(own)) + ylab("Proportion Own") + ggtitle("Histogram of Portland Proportion Owned Properties \n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# prent <- ggplot(ct_homcount.df) + geom_histogram(aes(rent)) + ylab("Proportion Rent") + ggtitle("Histogram of Portland Proportion Rented Properties\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))
# pfood <- ggplot(ct_homcount.df) + geom_histogram(aes(food)) + ylab("Percentage Houses Receiving Food Stamps") + ggtitle("Histogram of Portland Percentage Houses\n Receiving Food Stamps\n on Census Tracts") + theme_bw() + theme(plot.title = element_text(size = 30,hjust = 0.5),axis.title = element_text(size = 25),axis.text = element_text(size = 25),legend.title = element_text(size = 25),legend.text = element_text(size = 25))

ggsave(filename = "PPopHistCT.pdf",plot=ppop, height = 7.5, width=10)
ggsave(filename = "PImpIncHistCT.pdf",plot=pinc, height = 7.5, width=10)
# ggsave(filename = "PSexMHistCT.pdf",plot=pmsex, height = 7.5, width=10)
# ggsave(filename = "PSexFHistCT.pdf",plot=pfsex, height = 7.5, width=10)
# ggsave(filename = "POccOwnHistCT.pdf",plot=pown, height = 7.5, width=10)
# ggsave(filename = "POccRentHistCT.pdf",plot=prent, height = 7.5, width=10)
# ggsave(filename = "PFoodHistCT.pdf",plot=pfood, height = 7.5, width=10)




# sessionInfo() -----------------------------------------------------------

sessionInfo()