# Combining Grid-Mesh Simulation Study Results ----------------------------

# This script is to combine the outputs from the multiple processors in Balena into one complete data file for both the traditional and simulation study and for each case, Gaussian (SG), LGCP over a regular polygon (RegPol) or LGCP over the irregular LA polygon (IrregPol). This places the combined outputs into the relevant output folder, which would coincide with the location of the output files from Balena.

# Author: Nadeen Khaleel


# Setwd and Load Libraris -------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(spatstat)

# Set-up ------------------------------------------------------------------

sim.type <- "SBC" # "Trad" or "SBC"
mod.type <- "LGCP" # "SG" or "LGCP"
win.type <- "IrregPol" # "RegPol" or IrregPol
Nprocs <- 40 # 16 or 32 or 40 - how many procs did I use?
pred <- FALSE # TRUE or FALSE? - ALWAYS FALSE!
if (sim.type=="SBC"){
  # N <- 2560 # SG
  # L <- 127 # SG
  N <- 1000 # LGCP
  L <- 100 # LGCP
} else {
  N <- 1e3
}

# Used this set-up for Trad and SBC SG and Trad RegPol LGCP, but changed for SBC RegPol LGCP and Trad and SBC IrregPol LGCP
# if (round(N/Nprocs)==N/Nprocs){
#   M.it <- rep(N/Nprocs,length=Nprocs)
# } else {
#   M.it <- rep(0,length=Nprocs)
#   M.it[1:(Nprocs-1)] <- floor(N/Nprocs)
#   M.it[Nprocs] <- N - (Nprocs-1)*M.it[1]
# }

M.it <- rep(N%/%Nprocs,length=Nprocs)
if (N%%Nprocs!=0){M.it[1:(N%%Nprocs)] <- M.it[1:(N%%Nprocs)] + 1}

if (win.type=="RegPol"){
  W <- owin(c(0,5),c(0,5))
  if (mod.type=="SG"){
    setwd("./GAUSSIAN/GAUSSIAN_OUTPUT")
    load(paste0("GridMesh",mod.type,sim.type,"SS1.rda"))
    mesh.ind <- names(run.out); N.m <- length(mesh.ind)
    param.ind <- names(run.out[[1]]$est.df); N.p <- length(param.ind) # param <- c("Int","Beta1","Beta2","Sigma","Rho","Tau")
    
    # Final Data List
    list.mesh <- vector(mode="list",length=N.m)
    names(list.mesh) <- mesh.ind
    list.param <- vector(mode="list",length=3)
    names(list.param) <- c("est.df","run.df","mess.ls")
    list.param$est.df <- data.frame(beta0=rep(NA,N),beta0.sd=rep(NA,N),beta0.cil=rep(NA,N),beta0.ciu=rep(NA,N),beta1=rep(NA,N),beta1.sd=rep(NA,N),beta1.cil=rep(NA,N),beta1.ciu=rep(NA,N),beta2=rep(NA,N),beta2.sd=rep(NA,N),beta2.cil=rep(NA,N),beta2.ciu=rep(NA,N),sigma=rep(NA,N),sigma.sd=rep(NA,N),sigma.cil=rep(NA,N),sigma.ciu=rep(NA,N),rho=rep(NA,N),rho.sd=rep(NA,N),rho.cil=rep(NA,N),rho.ciu=rep(NA,N),tau=rep(NA,N),tau.sd=rep(NA,N),tau.cil=rep(NA,N),tau.ciu=rep(NA,N))
    list.param$run.df <- list(time=rep(NA,N),cpo=vector(mode="list",length=N),waic=rep(NA,N),dic=rep(NA,N))
    list.param$mess.ls <- list(error=rep(NA,N),warning=rep(NA,N),FFT=rep(NA,N),message=vector(mode="list",length=N))
    
    run.out.final <- lapply(list.mesh,function(x){x <- list.param})
    true.theta.final <- data.frame(beta0=rep(NA,N),beta1=rep(NA,N),beta2=rep(NA,N),sigma=rep(NA,N),rho=rep(NA,N),tau=rep(NA,N))
    
    if (sim.type=="Trad"){
      for (k in 1:Nprocs){
        load(paste0("GridMesh",mod.type,sim.type,"SS",k,".rda"))
        start.ind <- sum(M.it[0:(k-1)]) + 1
        end.ind <- sum(M.it[0:k])
        for (l in 1:N.m){
          run.out.final[[l]]$est.df[start.ind:end.ind,] <- run.out[[l]]$est.df
          run.out.final[[l]]$run.df$time[start.ind:end.ind] <- run.out[[l]]$run.df$time
          run.out.final[[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[l]]$run.df$cpo
          run.out.final[[l]]$run.df$waic[start.ind:end.ind] <- run.out[[l]]$run.df$waic
          run.out.final[[l]]$run.df$dic[start.ind:end.ind] <- run.out[[l]]$run.df$dic
          run.out.final[[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[l]]$mess.ls$error
          run.out.final[[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[l]]$mess.ls$warning
          run.out.final[[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[l]]$mess.ls$FFT
          run.out.final[[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[l]]$mess.ls$message
        }
      }
      
      save(run.out.final,file = paste0("GridMesh",mod.type,sim.type,"SS.rda"))
    } else {
      param.ind <- names(gm[[1]]$ranks.param); N.p <- length(param.ind)
      gm.final <- vector(mode="list",length=length(gm))
      names(gm.final) <- names(gm)
      rank.list <- list()
      rank.list$ranks.param <- data.frame(matrix(rep(NA,N.p*N),ncol=N.p))
      names(rank.list$ranks.param) <- param.ind
      N.f <- length(gm[[1]]$ranks.mf)
      rank.list$ranks.mf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
      names(rank.list$ranks.mf) <- names(gm[[1]]$ranks.mf)
      rank.list$ranks.gf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
      names(rank.list$ranks.gf) <- paste0("loc",1:N.f)
      gm.final <- lapply(gm.final,function(x){x <- rank.list})
     
      for (k in 1:Nprocs){
        load(paste0("GridMesh",mod.type,sim.type,"SS",k,".rda"))
        start.ind <- sum(M.it[0:(k-1)]) + 1
        end.ind <- sum(M.it[0:k])
        for (l in 1:N.m){
          run.out.final[[l]]$est.df[start.ind:end.ind,] <- run.out[[l]]$est.df
          run.out.final[[l]]$run.df$time[start.ind:end.ind] <- run.out[[l]]$run.df$time
          run.out.final[[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[l]]$run.df$cpo
          run.out.final[[l]]$run.df$waic[start.ind:end.ind] <- run.out[[l]]$run.df$waic
          run.out.final[[l]]$run.df$dic[start.ind:end.ind] <- run.out[[l]]$run.df$dic
          run.out.final[[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[l]]$mess.ls$error
          run.out.final[[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[l]]$mess.ls$warning
          run.out.final[[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[l]]$mess.ls$FFT
          run.out.final[[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[l]]$mess.ls$message
          
          gm.final[[l]]$ranks.param[start.ind:end.ind,] <- gm[[l]]$ranks.param
          gm.final[[l]]$ranks.mf[start.ind:end.ind,] <- gm[[l]]$ranks.mf
          gm.final[[l]]$ranks.gf[start.ind:end.ind,] <- gm[[l]]$ranks.gf
          
          true.theta.final[start.ind:end.ind,] <- true.theta
        }
      }
      
      save(run.out.final,gm.final,true.theta.final,file = paste0("GridMesh",mod.type,sim.type,"SS.rda"))
    }
  } else {
    setwd("./REGULAR_POLYGON_LGCP/REGPOLLGCP_OUTPUT")
    load(paste0("GridMesh",win.type,mod.type,sim.type,"SS1.rda"))
    grid.ind <- names(run.out); N.g <- length(grid.ind)
    mesh.ind <- names(run.out[[1]]); N.m <- length(mesh.ind)
    param.ind <- names(run.out[[1]][[1]]$est.df); N.p <- length(param.ind) # param <- c("Int","Beta1","Beta2","Sigma","Rho")
    
    # Final Data list
    list.grid <- vector(mode="list",length=N.g)
    names(list.grid) <- grid.ind
    list.mesh <- vector(mode="list",length=N.m)
    names(list.mesh) <- mesh.ind
    list.param <- vector(mode="list",length=3)
    names(list.param) <- c("est.df","run.df","mess.ls")
    if (sim.type=="Trad"){
      list.param$est.df <- data.frame(beta0=rep(NA,N),beta0.sd=rep(NA,N),beta0.cil=rep(NA,N),beta0.ciu=rep(NA,N),beta1=rep(NA,N),beta1.sd=rep(NA,N),beta1.cil=rep(NA,N),beta1.ciu=rep(NA,N),beta2=rep(NA,N),beta2.sd=rep(NA,N),beta2.cil=rep(NA,N),beta2.ciu=rep(NA,N),sigma=rep(NA,N),sigma.sd=rep(NA,N),sigma.cil=rep(NA,N),sigma.ciu=rep(NA,N),sigma.mode=rep(NA,N),rho=rep(NA,N),rho.sd=rep(NA,N),rho.cil=rep(NA,N),rho.ciu=rep(NA,N),rho.mode=rep(NA,N))
    } else { # SBC slight issue with set-up so the modes are at the end of the data frame.
      list.param$est.df <- data.frame(beta0=rep(NA,N),beta0.sd=rep(NA,N),beta0.cil=rep(NA,N),beta0.ciu=rep(NA,N),beta1=rep(NA,N),beta1.sd=rep(NA,N),beta1.cil=rep(NA,N),beta1.ciu=rep(NA,N),beta2=rep(NA,N),beta2.sd=rep(NA,N),beta2.cil=rep(NA,N),beta2.ciu=rep(NA,N),sigma=rep(NA,N),sigma.sd=rep(NA,N),sigma.cil=rep(NA,N),sigma.ciu=rep(NA,N),rho=rep(NA,N),rho.sd=rep(NA,N),rho.cil=rep(NA,N),rho.ciu=rep(NA,N),sigma.mode=rep(NA,N),rho.mode=rep(NA,N))
    }
    
    list.param$run.df <- list(time=rep(NA,N),waic=rep(NA,N),dic=rep(NA,N))
    list.param$mess.ls <- list(error=rep(NA,N),warning=rep(NA,N),FFT=rep(NA,N),message=vector(mode="list",length=N))
    
    list.meshparam <- lapply(list.mesh,function(x){x <- list.param})
    run.out.final <- lapply(list.grid,function(x){x <- list.meshparam})
    
    true.theta.final <- data.frame(beta0=rep(NA,N),beta1=rep(NA,N),beta2=rep(NA,N),sigma=rep(NA,N),rho=rep(NA,N))
    
    if (sim.type=="Trad"){
      for (k in 1:Nprocs){
        load(paste0("GridMesh",win.type,mod.type,sim.type,"SS",k,".rda"))
        start.ind <- sum(M.it[0:(k-1)]) + 1
        end.ind <- sum(M.it[0:k])
        for (j in 1:N.g){
          for (l in 1:N.m){
            run.out.final[[j]][[l]]$est.df[start.ind:end.ind,] <- run.out[[j]][[l]]$est.df
            run.out.final[[j]][[l]]$run.df$time[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$time
            run.out.final[[j]][[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$cpo
            run.out.final[[j]][[l]]$run.df$waic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$waic
            run.out.final[[j]][[l]]$run.df$dic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$dic
            run.out.final[[j]][[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$error
            run.out.final[[j]][[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$warning
            run.out.final[[j]][[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$FFT
            run.out.final[[j]][[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$message
          }
        }
      }
      
      save(run.out.final,file = paste0("GridMesh",win.type,mod.type,sim.type,"SS.rda"))
    } else {
      param.ind <- names(gm[[1]]$ranks.param); N.p <- length(param.ind)
      gm.final <- vector(mode="list",length=length(gm))
      names(gm.final) <- names(gm)
      rank.list <- list()
      rank.list$ranks.param <- data.frame(matrix(rep(NA,N.p*N),ncol=N.p))
      names(rank.list$ranks.param) <- param.ind
      N.f <- length(gm[[1]]$ranks.mf)
      rank.list$ranks.mf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
      names(rank.list$ranks.mf) <- names(gm[[1]]$ranks.mf)
      gm.final <- lapply(gm.final,function(x){x <- rank.list})
      if (pred==FALSE){
        for (i in 1:N.g){
          for (j in 1:N.m){
            gm.final.ind <- (i-1)*N.m + j
            N.f <- length(gm[[gm.final.ind]]$ranks.mf)
            gm.final[[gm.final.ind]]$ranks.mf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
            names(gm.final[[gm.final.ind]]$ranks.mf) <- paste0("loc",1:N.f)
          }
        }
      }
      
      for (k in 1:Nprocs){
        load(paste0("GridMesh",win.type,mod.type,sim.type,"SS",k,".rda"))
        start.ind <- sum(M.it[0:(k-1)]) + 1
        end.ind <- sum(M.it[0:k])
        for (j in 1:N.g){
          for (l in 1:N.m){
            run.out.final[[j]][[l]]$est.df[start.ind:end.ind,] <- run.out[[j]][[l]]$est.df
            run.out.final[[j]][[l]]$run.df$time[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$time
            run.out.final[[j]][[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$cpo
            run.out.final[[j]][[l]]$run.df$waic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$waic
            run.out.final[[j]][[l]]$run.df$dic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$dic
            run.out.final[[j]][[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$error
            run.out.final[[j]][[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$warning
            run.out.final[[j]][[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$FFT
            run.out.final[[j]][[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$message
            
            ind <- (j-1)*N.m + l
            gm.final[[ind]]$ranks.param[start.ind:end.ind,] <- gm[[ind]]$ranks.param
            gm.final[[ind]]$ranks.mf[start.ind:end.ind,] <- gm[[ind]]$ranks.mf
            # gm.final[[ind]]$ranks.gf[start.ind:end.ind,] <- gm[[ind]]$ranks.gf
            
            true.theta.final[start.ind:end.ind,] <- true.theta
          }
        }
      }
      save(run.out.final,gm.final,true.theta.final,file = paste0("GridMesh",win.type,mod.type,sim.type,"SS.rda"))
    }
  }
} else {
  setwd("./IRREGULAR_POLYGON_LGCP/IRREGPOLLGCP_OUTPUT/")
  load(paste0("GridMesh",win.type,mod.type,sim.type,"SS1.rda"))
  grid.ind <- names(run.out); N.g <- length(grid.ind)
  mesh.ind <- names(run.out[[1]]); N.m <- length(mesh.ind)
  param.ind <- names(run.out[[1]][[1]]$est.df); N.p <- length(param.ind) # param <- c("Int","Beta1","Beta2","Sigma","Rho")
  
  # Final Data list
  list.grid <- vector(mode="list",length=N.g)
  names(list.grid) <- grid.ind
  list.mesh <- vector(mode="list",length=N.m)
  names(list.mesh) <- mesh.ind
  list.param <- vector(mode="list",length=3)
  names(list.param) <- c("est.df","run.df","mess.ls")
  list.param$est.df <- data.frame(beta0=rep(NA,N),beta0.sd=rep(NA,N),beta0.cil=rep(NA,N),beta0.ciu=rep(NA,N),beta1=rep(NA,N),beta1.sd=rep(NA,N),beta1.cil=rep(NA,N),beta1.ciu=rep(NA,N),beta2=rep(NA,N),beta2.sd=rep(NA,N),beta2.cil=rep(NA,N),beta2.ciu=rep(NA,N),sigma=rep(NA,N),sigma.sd=rep(NA,N),sigma.cil=rep(NA,N),sigma.ciu=rep(NA,N),sigma.mode=rep(NA,N),rho=rep(NA,N),rho.sd=rep(NA,N),rho.cil=rep(NA,N),rho.ciu=rep(NA,N),rho.mode=rep(NA,N))
  
  list.param$run.df <- list(time=rep(NA,N),waic=rep(NA,N),dic=rep(NA,N))
  list.param$mess.ls <- list(error=rep(NA,N),warning=rep(NA,N),FFT=rep(NA,N),message=vector(mode="list",length=N))
  
  list.meshparam <- lapply(list.mesh,function(x){x <- list.param})
  run.out.final <- lapply(list.grid,function(x){x <- list.meshparam})
  
  true.theta.final <- data.frame(beta0=rep(NA,N),beta1=rep(NA,N),beta2=rep(NA,N),sigma=rep(NA,N),rho=rep(NA,N))
  
  if (sim.type=="Trad"){
    for (k in 1:Nprocs){
      load(paste0("GridMesh",win.type,mod.type,sim.type,"SS",k,".rda"))
      start.ind <- sum(M.it[0:(k-1)]) + 1
      end.ind <- sum(M.it[0:k])
      for (j in 1:N.g){
        for (l in 1:N.m){
          run.out.final[[j]][[l]]$est.df[start.ind:end.ind,] <- run.out[[j]][[l]]$est.df
          run.out.final[[j]][[l]]$run.df$time[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$time
          # run.out.final[[j]][[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$cpo
          run.out.final[[j]][[l]]$run.df$waic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$waic
          run.out.final[[j]][[l]]$run.df$dic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$dic
          run.out.final[[j]][[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$error
          run.out.final[[j]][[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$warning
          run.out.final[[j]][[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$FFT
          run.out.final[[j]][[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$message
        }
      }
    }

    save(run.out.final,file = paste0("GridMesh",win.type,mod.type,sim.type,"SS.rda"))
  } else {
    param.ind <- names(gm[[1]]$ranks.param); N.p <- length(param.ind)
    gm.final <- vector(mode="list",length=length(gm))
    names(gm.final) <- names(gm)
    rank.list <- list()
    rank.list$ranks.param <- data.frame(matrix(rep(NA,N.p*N),ncol=N.p))
    names(rank.list$ranks.param) <- param.ind
    N.f <- length(gm[[1]]$ranks.mf)
    rank.list$ranks.mf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
    names(rank.list$ranks.mf) <- names(gm[[1]]$ranks.mf)
    gm.final <- lapply(gm.final,function(x){x <- rank.list})
    if (pred==FALSE){
      for (i in 1:N.g){
        for (j in 1:N.m){
          gm.final.ind <- (i-1)*N.m + j
          N.f <- length(gm[[gm.final.ind]]$ranks.mf)
          gm.final[[gm.final.ind]]$ranks.mf <- data.frame(matrix(rep(NA,N.f*N),ncol=N.f))
          names(gm.final[[gm.final.ind]]$ranks.mf) <- paste0("loc",1:N.f)
        }
      }
    }
    
    for (k in 1:Nprocs){
      load(paste0("GridMesh",win.type,mod.type,sim.type,"SS",k,".rda"))
      start.ind <- sum(M.it[0:(k-1)]) + 1
      end.ind <- sum(M.it[0:k])
      for (j in 1:N.g){
        for (l in 1:N.m){
          run.out.final[[j]][[l]]$est.df[start.ind:end.ind,] <- run.out[[j]][[l]]$est.df
          run.out.final[[j]][[l]]$run.df$time[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$time
          # run.out.final[[j]][[l]]$run.df$cpo[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$cpo
          run.out.final[[j]][[l]]$run.df$waic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$waic
          run.out.final[[j]][[l]]$run.df$dic[start.ind:end.ind] <- run.out[[j]][[l]]$run.df$dic
          run.out.final[[j]][[l]]$mess.ls$error[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$error
          run.out.final[[j]][[l]]$mess.ls$warning[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$warning
          run.out.final[[j]][[l]]$mess.ls$FFT[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$FFT
          run.out.final[[j]][[l]]$mess.ls$message[start.ind:end.ind] <- run.out[[j]][[l]]$mess.ls$message
          
          ind <- (j-1)*N.m + l
          gm.final[[ind]]$ranks.param[start.ind:end.ind,] <- gm[[ind]]$ranks.param
          gm.final[[ind]]$ranks.mf[start.ind:end.ind,] <- gm[[ind]]$ranks.mf
          # gm.final[[ind]]$ranks.gf[start.ind:end.ind,] <- gm[[ind]]$ranks.gf
          
          true.theta.final[start.ind:end.ind,] <- true.theta
        }
      }
    }
    save(run.out.final,gm.final,true.theta.final,file = paste0("GridMesh",win.type,mod.type,sim.type,"SS.rda"))
  }
}


