
# Parameters Causing Errors in SBC for Gaussian Example Grid Mesh ---------

# Check the parameter values where there are errors or FFT warnings occurring more than 10 times.

# Author: Nadeen Khaleel

# Setwd and Load Libraries ------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))


# SBC Simulation Study ----------------------------------------------------

# SBC: Parameters for Errors ----------------------------------------------
# What parameter values result in errors?

load("../GAUSSIAN_OUTPUT/GridMeshSGSBCSS.rda")

for (l in 1:4){
  print(paste0("Mesh ",l))
  err.tot.jl <- sum(!is.na(run.out.final[[l]]$mess.ls$error))
  if (err.tot.jl >0){
    data.ind <- which((!is.na(run.out.final[[l]]$mess.ls$error)))
    print("theta values for errors")
    for (i in 1:length(data.ind)){
      print(true.theta.final[data.ind[i],])
    }
  }
  
}

# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0    beta1   beta2    sigma      rho      tau
# 1156 76.68879 11.18164 35.7729 0.143827 35.26817 15.81514
# beta0      beta1     beta2       sigma      rho      tau
# 2291 -21.55799 -0.6290255 -16.99816 0.005167183 1.632818 37.09222
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0    beta1    beta2       sigma       rho     tau
# 1424 54.88868 -63.4418 -81.7812 0.008975999 0.7135963 13.1051
# [1] "Mesh 3"
# [1] "Mesh 4"



# SBC: Parameters for FFT -------------------------------------------------
# What parameter values result in more than 10 FFT warnings.

for (l in 1:4){
  print(paste0("Mesh ",l))
  err.tot.jl <- sum((run.out.final[[l]]$mess.ls$FFT)>10,na.rm=T)
  if (err.tot.jl >0){
    data.ind <- which(((run.out.final[[l]]$mess.ls$FFT)>10))
    print("theta values for errors")
    for (i in 1:length(data.ind)){
      print(true.theta.final[data.ind[i],])
    }
  }
  
}
# }
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0    beta1     beta2    sigma      rho      tau
# 262 -25.22056 -10.6759 -2.839192 1.035749 1.257473 35.68869
# beta0    beta1     beta2     sigma     rho      tau
# 414 -70.83161 7.965448 -42.16744 0.2475388 121.731 5.523062
# beta0     beta1    beta2        sigma     rho      tau
# 538 -27.83371 -36.69494 20.23092 0.0004531475 2.08067 6.053843
# beta0    beta1    beta2     sigma      rho      tau
# 569 -17.17193 28.91963 -54.1451 0.5134262 895.6004 16.19271
# beta0     beta1    beta2     sigma      rho      tau
# 587 -85.0209 -1.607604 53.55862 0.7267166 448.9032 16.92724
# beta0     beta1    beta2    sigma     rho      tau
# 807 37.64351 0.2532543 -43.3947 2.334348 2.92294 36.89298
# beta0     beta1    beta2   sigma      rho      tau
# 947 2.790494 -48.61998 24.45419 1.17118 2.083724 9.529548
# beta0     beta1    beta2    sigma      rho      tau
# 976 -10.10418 -47.67083 17.65785 1.508106 1.941754 11.07254
# beta0   beta1     beta2    sigma      rho      tau
# 1018 67.54254 1.40128 -8.498993 2.224745 1.493953 18.40427
# beta0    beta1    beta2     sigma       rho      tau
# 1029 -6.564273 15.94775 21.76952 0.6672986 0.3951701 7.241151
# beta0     beta1   beta2    sigma      rho      tau
# 1138 17.73186 -16.02811 9.93265 1.113115 1.304525 24.48122
# beta0    beta1     beta2    sigma       rho      tau
# 1165 18.41327 37.92469 -54.85268 1.585933 0.7210107 14.69525
# beta0     beta1    beta2       sigma      rho      tau
# 1245 -17.93753 -69.55371 1.853748 0.006249775 143.7908 9.316056
# beta0     beta1    beta2    sigma      rho      tau
# 1292 -1.906239 -30.30772 16.07486 2.226679 3.606175 10.53828
# beta0     beta1    beta2     sigma      rho      tau
# 1594 17.70558 -12.07841 37.67915 0.0231245 11.96831 22.98252
# beta0    beta1    beta2    sigma       rho      tau
# 1662 -19.54866 63.62138 39.82529 1.717014 0.8396312 18.72452
# beta0     beta1     beta2      sigma      rho      tau
# 1767 55.10073 -13.18774 -7.185786 0.01274831 5.738558 7.557147
# beta0    beta1     beta2      sigma      rho      tau
# 1775 32.93261 18.75856 -18.34446 0.02391197 319.3186 33.69573
# beta0    beta1    beta2       sigma      rho      tau
# 1826 33.00942 56.83323 -14.0194 0.002297734 2.301361 13.69428
# beta0     beta1    beta2      sigma      rho      tau
# 1896 -7.891026 -56.00134 25.06067 0.01237566 20.37488 30.20242
# beta0    beta1     beta2    sigma     rho      tau
# 1942 7.363141 10.40468 -14.04797 3.036435 4.24141 31.02172
# beta0    beta1     beta2      sigma      rho      tau
# 2152 -10.56525 47.77311 -34.33093 0.03144408 7.282546 35.64969
# beta0     beta1    beta2      sigma      rho      tau
# 2213 -36.44793 -70.74034 10.66142 0.00259065 13.81749 8.317204
# beta0     beta1    beta2    sigma      rho      tau
# 2308 -26.56804 -10.55753 29.41771 1.194996 1.883453 4.037396
# beta0   beta1    beta2      sigma      rho      tau
# 2507 -5.866678 62.8345 86.20098 0.02410673 4.453382 17.54272
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0   beta1     beta2      sigma      rho      tau
# 12 22.7888 15.8084 -18.18591 0.03777438 7.870107 13.17783
# beta0    beta1    beta2    sigma     rho      tau
# 131 25.15531 9.976078 7.110242 2.934348 1.46867 33.73751
# beta0    beta1    beta2    sigma      rho      tau
# 199 20.95167 70.68095 -69.9149 3.776478 1.273984 5.813121
# beta0    beta1     beta2    sigma      rho      tau
# 248 20.95519 17.03491 -7.798098 3.650469 1.462058 4.894299
# beta0    beta1     beta2    sigma     rho      tau
# 433 -33.41915 6.447705 -39.54385 2.433464 1.39117 17.36093
# beta0    beta1    beta2    sigma      rho      tau
# 512 16.41456 9.710294 -17.5267 2.053061 1.875823 1.258695
# beta0     beta1    beta2        sigma     rho      tau
# 538 -27.83371 -36.69494 20.23092 0.0004531475 2.08067 6.053843
# beta0     beta1    beta2    sigma       rho      tau
# 704 2.897876 -31.43411 43.76611 1.529726 0.8626578 27.91503
# beta0     beta1     beta2       sigma      rho      tau
# 787 35.52457 -9.585269 -27.02385 0.006739726 1.030124 12.00274
# beta0    beta1     beta2    sigma       rho      tau
# 924 18.56855 24.73727 -6.996166 3.265777 0.8301924 9.031065
# beta0     beta1     beta2    sigma      rho      tau
# 937 -27.40999 -44.89703 -40.71355 2.898368 1.069639 40.63134
# beta0   beta1    beta2      sigma      rho      tau
# 988 -31.31844 12.0121 59.93094 0.02157151 9.198381 12.62283
# beta0    beta1    beta2     sigma      rho      tau
# 997 -77.73272 24.80636 -37.2971 0.3390766 3654.783 8.020451
# beta0   beta1     beta2    sigma      rho      tau
# 1018 67.54254 1.40128 -8.498993 2.224745 1.493953 18.40427
# beta0     beta1     beta2        sigma      rho      tau
# 1049 46.38419 -5.541824 -69.76614 0.0008633389 14.13741 28.85564
# beta0    beta1      beta2    sigma      rho      tau
# 1054 35.09378 5.012851 -0.8056329 3.065374 2.152349 12.16955
# beta0     beta1    beta2      sigma      rho      tau
# 1091 -1.589074 -61.33779 13.87114 0.04690444 2.860379 6.161851
# beta0    beta1     beta2      sigma      rho      tau
# 1143 55.25583 -6.60062 -18.31643 0.01601747 1.021932 10.61932
# beta0   beta1     beta2      sigma       rho      tau
# 1453 5.29267 39.2907 -33.69044 0.01975908 0.7739851 16.54383
# beta0     beta1    beta2    sigma       rho      tau
# 1497 -51.22058 -42.35862 51.46306 2.527546 0.9153595 42.04465
# beta0    beta1     beta2    sigma       rho      tau
# 1544 -13.11257 10.44703 -1.408392 4.018417 0.7063964 13.03619
# beta0    beta1     beta2   sigma       rho      tau
# 1681 -1.278473 8.669926 -14.60398 1.77666 0.7250872 55.52886
# beta0    beta1    beta2   sigma      rho      tau
# 1702 -37.83885 1.705347 13.27679 4.54598 2.892286 22.99411
# beta0    beta1    beta2    sigma      rho      tau
# 1722 27.04216 17.24446 49.29888 2.024574 1.019653 32.93923
# beta0     beta1    beta2     sigma      rho      tau
# 1792 -3.122165 -54.74147 9.838504 0.1624359 516.2329 19.03775
# beta0    beta1     beta2    sigma      rho      tau
# 1808 25.71804 36.71309 -3.082541 3.083335 1.900801 9.681762
# beta0    beta1    beta2       sigma      rho      tau
# 1826 33.00942 56.83323 -14.0194 0.002297734 2.301361 13.69428
# beta0    beta1    beta2      sigma      rho      tau
# 1874 12.71259 21.07775 22.85046 0.08509515 142.4616 5.963942
# beta0    beta1     beta2    sigma       rho      tau
# 1954 13.15338 37.70351 -50.93018 1.082335 0.5695155 10.69026
# beta0     beta1     beta2      sigma       rho     tau
# 2043 -7.005803 -12.14521 -19.37275 0.07366247 0.3527016 3.69853
# beta0    beta1    beta2       sigma      rho      tau
# 2103 2.083435 57.45904 7.777883 0.003055814 103.8464 2.588006
# beta0    beta1    beta2      sigma      rho    tau
# 2117 -20.92568 39.71632 20.83179 0.01353611 17.08469 25.301
# beta0     beta1    beta2      sigma      rho      tau
# 2203 36.92458 -35.99938 61.24482 0.03925997 3.246226 5.410701
# beta0     beta1     beta2   sigma      rho      tau
# 2210 -20.22009 -22.22001 -54.39026 4.96601 1.817606 10.52449
# beta0    beta1    beta2    sigma      rho     tau
# 2261 70.0154 2.522043 28.92596 3.565468 1.312486 30.1263
# beta0     beta1     beta2    sigma      rho      tau
# 2289 8.862521 -12.69916 -43.03194 3.259025 2.123282 25.84387
# beta0     beta1      beta2    sigma      rho      tau
# 2324 0.4323911 -55.22135 -0.7816994 3.600307 1.801176 16.12666
# beta0     beta1     beta2      sigma     rho      tau
# 2348 52.24088 -42.98564 -27.27181 0.01343729 2.37369 21.82433
# beta0    beta1    beta2    sigma      rho      tau
# 2384 -22.68396 -37.4699 15.23957 1.845343 1.345645 11.02394
# beta0    beta1    beta2    sigma      rho      tau
# 2435 -35.34043 30.45381 4.451984 3.383025 2.184668 34.45207
# beta0   beta1    beta2      sigma      rho      tau
# 2507 -5.866678 62.8345 86.20098 0.02410673 4.453382 17.54272
# [1] "Mesh 3"
# [1] "theta values for errors"
# beta0     beta1    beta2      sigma      rho      tau
# 17 -0.4543259 -17.82575 5.938735 0.01740521 16.95834 5.758898
# beta0    beta1     beta2       sigma      rho      tau
# 68 -4.976582 -37.9112 -28.11913 0.009774505 5.477082 29.90393
# beta0    beta1    beta2    sigma     rho      tau
# 175 25.74681 12.36903 42.57079 8.591405 1.25105 4.689888
# beta0     beta1    beta2    sigma       rho      tau
# 177 -46.73519 -13.44844 41.36604 5.412722 0.7573849 9.113723
# beta0     beta1      beta2      sigma      rho      tau
# 258 -21.25064 0.7387042 -0.5208856 0.06081944 38.70503 12.85407
# beta0    beta1    beta2      sigma      rho      tau
# 393 -48.22125 1.381224 27.92561 0.04347864 1.655424 7.289727
# beta0    beta1    beta2    sigma      rho      tau
# 401 -3.483557 -41.9509 20.81174 2.968854 1.453582 6.635318
# beta0    beta1     beta2      sigma      rho      tau
# 416 -33.60112 13.64437 -71.58998 0.01645032 1.167431 17.94028
# beta0     beta1    beta2        sigma     rho      tau
# 538 -27.83371 -36.69494 20.23092 0.0004531475 2.08067 6.053843
# beta0    beta1    beta2    sigma       rho      tau
# 598 51.02533 19.26798 1.926083 1.281281 0.5238544 29.43606
# beta0     beta1     beta2      sigma      rho      tau
# 635 -8.996034 -22.03513 -11.72394 0.05177956 130.3388 6.890232
# beta0     beta1     beta2    sigma       rho      tau
# 691 -30.45241 -21.47266 -44.95937 2.212358 0.9136189 14.60499
# beta0   beta1    beta2    sigma       rho      tau
# 727 4.782231 24.2781 4.595415 1.598673 0.5840254 21.19355
# beta0    beta1     beta2    sigma       rho      tau
# 742 -24.85781 22.54052 -80.41855 1.992393 0.6602199 19.48232
# beta0     beta1     beta2      sigma       rho      tau
# 819 -29.30178 -44.84966 -19.45027 0.01549675 0.4241285 6.264043
# beta0    beta1    beta2    sigma       rho      tau
# 873 -14.79634 15.69113 3.468993 1.488703 0.7462092 21.85471
# beta0   beta1    beta2      sigma      rho      tau
# 988 -31.31844 12.0121 59.93094 0.02157151 9.198381 12.62283
# beta0     beta1     beta2        sigma      rho      tau
# 1049 46.38419 -5.541824 -69.76614 0.0008633389 14.13741 28.85564
# beta0     beta1    beta2      sigma      rho      tau
# 1057 41.1001 -10.05008 4.614175 0.02358885 221.4634 27.40504
# beta0    beta1     beta2      sigma     rho      tau
# 1060 18.58406 -38.2873 -25.07086 0.03875862 8.21266 7.036516
# beta0    beta1     beta2      sigma      rho      tau
# 1240 -49.63166 14.12624 -20.61821 0.08052078 48.51555 61.52351
# beta0     beta1    beta2       sigma      rho      tau
# 1245 -17.93753 -69.55371 1.853748 0.006249775 143.7908 9.316056
# beta0    beta1    beta2       sigma       rho      tau
# 1255 6.059825 17.91788 21.37612 0.007277612 0.9158425 14.43239
# beta0    beta1    beta2    sigma       rho      tau
# 1534 29.0074 35.25177 11.81522 2.370344 0.8875787 34.49646
# beta0     beta1    beta2     sigma      rho      tau
# 1594 17.70558 -12.07841 37.67915 0.0231245 11.96831 22.98252
# beta0     beta1    beta2      sigma      rho      tau
# 1733 49.72369 -17.03386 5.958378 0.03206995 18.09918 10.18158
# beta0     beta1   beta2    sigma       rho      tau
# 1765 -19.8068 -68.75529 -50.197 3.688001 0.9364694 34.76304
# beta0     beta1     beta2      sigma      rho      tau
# 1767 55.10073 -13.18774 -7.185786 0.01274831 5.738558 7.557147
# beta0     beta1    beta2     sigma      rho      tau
# 1792 -3.122165 -54.74147 9.838504 0.1624359 516.2329 19.03775
# beta0     beta1     beta2    sigma     rho      tau
# 1799 -5.594372 -55.12779 -25.00036 2.219589 1.19073 16.76724
# beta0    beta1    beta2       sigma      rho      tau
# 1826 33.00942 56.83323 -14.0194 0.002297734 2.301361 13.69428
# beta0    beta1     beta2      sigma      rho      tau
# 1833 -8.000305 6.233839 -3.094715 0.05376547 1.253801 7.758198
# beta0    beta1    beta2      sigma      rho      tau
# 1874 12.71259 21.07775 22.85046 0.08509515 142.4616 5.963942
# beta0   beta1     beta2      sigma      rho      tau
# 1983 -34.07532 8.29455 -15.48568 0.02420779 12.63779 6.245994
# beta0    beta1    beta2      sigma      rho    tau
# 2117 -20.92568 39.71632 20.83179 0.01353611 17.08469 25.301
# beta0      beta1     beta2    sigma       rho    tau
# 2190 16.68898 -0.9605723 -50.37655 1.914113 0.7896841 18.421
# beta0     beta1    beta2     sigma      rho      tau
# 2235 -28.51639 -38.53514 23.62712 0.8898284 313.7091 26.98016
# beta0      beta1     beta2       sigma      rho      tau
# 2291 -21.55799 -0.6290255 -16.99816 0.005167183 1.632818 37.09222
# beta0    beta1     beta2   sigma       rho      tau
# 2301 21.30691 15.52889 -14.62133 2.36975 0.9746516 11.88573
# beta0     beta1     beta2      sigma      rho      tau
# 2310 -14.36681 -10.37166 -15.17013 0.02256269 1.083724 20.64678
# beta0     beta1    beta2    sigma     rho      tau
# 2315 -9.310035 -30.72093 -23.3998 2.684447 1.54623 10.32019
# beta0    beta1     beta2   sigma       rho      tau
# 2339 -7.972593 -37.8068 -17.86093 1.55667 0.6119787 18.65454
# beta0     beta1     beta2      sigma     rho      tau
# 2348 52.24088 -42.98564 -27.27181 0.01343729 2.37369 21.82433
# beta0    beta1     beta2    sigma      rho      tau
# 2362 -33.81956 38.48792 -21.78816 2.231463 1.808792 5.923805
# beta0    beta1    beta2     sigma      rho      tau
# 2369 16.76127 4.071885 51.95688 0.1303388 325.5266 19.99059
# beta0     beta1    beta2      sigma      rho      tau
# 2406 23.52275 -13.06092 80.21536 0.01210746 1.356601 9.986399
# beta0     beta1    beta2      sigma      rho      tau
# 2463 10.29965 -39.46909 50.08924 0.01974843 2.435397 6.623022
# beta0   beta1    beta2      sigma      rho      tau
# 2507 -5.866678 62.8345 86.20098 0.02410673 4.453382 17.54272
# beta0    beta1    beta2      sigma      rho      tau
# 2552 37.9782 3.756248 44.59144 0.03247457 55.25257 13.04628
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0   beta1     beta2      sigma      rho      tau
# 12 22.7888 15.8084 -18.18591 0.03777438 7.870107 13.17783
# beta0    beta1   beta2     sigma      rho      tau
# 55 7.981621 18.91801 39.8252 0.0280797 3.537795 24.60653
# beta0     beta1    beta2     sigma      rho     tau
# 92 -3.52281 -26.36235 26.28139 0.4457492 508.6488 24.3926
# beta0     beta1     beta2     sigma      rho      tau
# 97 -35.56116 -75.29439 -15.03061 0.0174446 1.308431 9.815538
# beta0     beta1    beta2     sigma      rho      tau
# 114 2.730389 -10.14174 43.54341 0.0517141 62.44578 33.44976
# beta0   beta1    beta2     sigma      rho     tau
# 369 71.69202 24.5522 41.73244 0.7293049 104.4746 75.1481
# beta0    beta1    beta2      sigma      rho      tau
# 393 -48.22125 1.381224 27.92561 0.04347864 1.655424 7.289727
# beta0    beta1     beta2      sigma       rho      tau
# 417 42.52465 20.38749 -51.44565 0.03066389 0.5880227 11.54176
# beta0    beta1   beta2     sigma      rho     tau
# 427 -27.63688 17.20558 24.5504 0.1581088 29.49302 33.8189
# beta0     beta1     beta2       sigma      rho      tau
# 431 -1.731046 -61.27079 -27.00126 0.007562499 1.292102 2.098873
# beta0     beta1     beta2     sigma      rho      tau
# 467 3.621423 -18.15091 -36.06353 0.1237685 26.44184 25.17052
# beta0     beta1     beta2      sigma      rho      tau
# 504 5.01583 -11.12026 -6.066929 0.02900569 17.61622 24.11532
# beta0    beta1     beta2      sigma      rho      tau
# 530 -1.8739 16.55739 -25.20939 0.05337443 4.137435 51.34925
# beta0    beta1    beta2    sigma      rho      tau
# 536 -35.47465 4.929058 1.212237 0.540578 108.0283 32.33566
# beta0    beta1     beta2     sigma     rho      tau
# 576 -57.1945 -35.0215 -46.94389 0.2742631 362.587 11.62872
# beta0     beta1     beta2      sigma      rho      tau
# 612 -45.72009 -19.01185 -16.53426 0.03728186 4.471954 5.798423
# beta0     beta1     beta2      sigma       rho      tau
# 636 53.48986 -4.252513 -35.69279 0.05113132 0.3574896 10.24709
# beta0     beta1    beta2     sigma      rho      tau
# 638 23.05429 -18.31261 -9.48945 0.9850147 134.2326 32.41131
# beta0    beta1     beta2       sigma       rho      tau
# 743 2.456571 24.00262 -25.05527 0.007169725 0.8266276 16.92023
# beta0    beta1      beta2     sigma      rho      tau
# 753 -61.39135 9.036211 0.04006848 0.1337367 8.938801 44.00763
# beta0     beta1     beta2     sigma      rho      tau
# 820 57.3164 -21.86264 -38.23215 0.4561252 167.5464 34.63392
# beta0     beta1     beta2      sigma      rho      tau
# 954 -15.66765 -53.67217 -81.98182 0.07090873 9.074851 20.05009
# beta0   beta1    beta2      sigma      rho      tau
# 988 -31.31844 12.0121 59.93094 0.02157151 9.198381 12.62283
# beta0    beta1    beta2     sigma      rho      tau
# 997 -77.73272 24.80636 -37.2971 0.3390766 3654.783 8.020451
# beta0     beta1     beta2      sigma      rho      tau
# 1093 26.24023 -50.89356 -9.495277 0.01513274 6.497101 24.07857
# beta0     beta1    beta2     sigma      rho      tau
# 1108 -9.031833 -21.31479 57.39713 0.0135784 1.916367 17.15069
# beta0     beta1     beta2     sigma      rho      tau
# 1213 7.106231 -73.31991 -8.824255 0.2993456 33.76142 48.67234
# beta0    beta1     beta2      sigma      rho      tau
# 1240 -49.63166 14.12624 -20.61821 0.08052078 48.51555 61.52351
# beta0    beta1     beta2     sigma      rho      tau
# 1258 29.74924 18.16535 -43.51531 0.1950881 31.76477 29.31147
# beta0    beta1     beta2     sigma      rho      tau
# 1330 15.93757 21.98461 -13.52256 0.0406769 4.138583 25.50259
# beta0    beta1    beta2      sigma      rho      tau
# 1339 38.22292 11.49935 10.28826 0.03977032 4.916985 46.55094
# beta0   beta1    beta2      sigma      rho      tau
# 1341 -71.19806 55.5471 8.999549 0.02198662 2.094477 29.53911
# beta0     beta1     beta2      sigma      rho      tau
# 1470 -2.766544 -26.26287 -12.30614 0.03306761 6.353986 12.32069
# beta0    beta1    beta2        sigma      rho     tau
# 1481 -0.1947145 47.47039 3.756515 0.0004324033 2.773106 17.0618
# beta0     beta1     beta2      sigma      rho      tau
# 1577 67.07833 -7.357817 -7.212941 0.05848018 7.609272 7.092982
# beta0     beta1    beta2     sigma      rho      tau
# 1594 17.70558 -12.07841 37.67915 0.0231245 11.96831 22.98252
# beta0     beta1    beta2     sigma      rho     tau
# 1663 34.41893 -17.73907 20.26874 0.5766063 52.29775 17.1417
# beta0     beta1    beta2      sigma      rho      tau
# 1733 49.72369 -17.03386 5.958378 0.03206995 18.09918 10.18158
# beta0     beta1    beta2     sigma      rho      tau
# 1757 40.51303 -25.53618 12.56889 0.5027639 172.1454 19.00024
# beta0    beta1     beta2      sigma      rho      tau
# 1775 32.93261 18.75856 -18.34446 0.02391197 319.3186 33.69573
# beta0     beta1    beta2     sigma      rho      tau
# 1792 -3.122165 -54.74147 9.838504 0.1624359 516.2329 19.03775
# beta0     beta1     beta2      sigma      rho      tau
# 1824 1.926227 -1.460538 -35.66696 0.02157559 1.326942 10.73547
# beta0     beta1    beta2      sigma      rho      tau
# 1896 -7.891026 -56.00134 25.06067 0.01237566 20.37488 30.20242
# beta0     beta1   beta2      sigma      rho      tau
# 1973 30.04955 -25.03224 -46.083 0.04068448 3.859685 17.88831
# beta0   beta1     beta2      sigma      rho      tau
# 1983 -34.07532 8.29455 -15.48568 0.02420779 12.63779 6.245994
# beta0    beta1     beta2     sigma      rho      tau
# 2032 8.492088 10.19637 -11.97263 0.1912894 93.15352 38.49116
# beta0     beta1    beta2      sigma       rho      tau
# 2054 -15.30216 -42.65573 24.74004 0.01979773 0.6318304 29.70663
# beta0     beta1    beta2      sigma      rho      tau
# 2087 -14.9658 -40.33459 1.286101 0.03650172 1.290854 37.56283
# beta0     beta1     beta2      sigma      rho      tau
# 2164 18.22205 -2.389226 -10.15073 0.06471307 22.05319 18.56651
# beta0     beta1    beta2     sigma      rho      tau
# 2235 -28.51639 -38.53514 23.62712 0.8898284 313.7091 26.98016
# beta0     beta1     beta2      sigma      rho      tau
# 2310 -14.36681 -10.37166 -15.17013 0.02256269 1.083724 20.64678
# beta0    beta1   beta2      sigma      rho      tau
# 2381 -5.117945 4.935449 21.1928 0.06921245 286.8998 20.47672
# beta0      beta1     beta2      sigma      rho      tau
# 2401 59.34885 -0.8901199 -9.530119 0.09434715 11.21527 36.01215
# beta0     beta1    beta2      sigma      rho      tau
# 2406 23.52275 -13.06092 80.21536 0.01210746 1.356601 9.986399
# beta0     beta1     beta2     sigma      rho      tau
# 2494 -59.97251 -62.60306 -19.29313 0.5966114 52.18046 21.85287
# beta0   beta1    beta2      sigma      rho      tau
# 2507 -5.866678 62.8345 86.20098 0.02410673 4.453382 17.54272
# beta0    beta1     beta2      sigma      rho     tau
# 2535 -29.77157 32.15999 -48.17937 0.06162392 24.03692 5.45319
