
# Simple Gaussian Example: Tables at 3 Sig. Fig. --------------------------

# This re-creates the traditional simulation study table of results with outputs reported to three significant figures.

# Author: Nadeen Khaleel

# Libraries and Working Directory -----------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(purrr)
library(ggplot2)
library(magrittr)
library(grid)
library(gridExtra)
library(stringr)
library(xtable)
library(tidyverse)


# Table Functions ---------------------------------------------------------

# The functions below were taken from GridMeshSGTradOutput_final.R

time.meansd.mesh <- function(grid.dat){
  N <- length(grid.dat[[1]]$run.df$time)
  meshes <- names(grid.dat); N.m <- length(meshes)
  means <- sapply(1:N.m,function(i){mean(grid.dat[[i]]$run.df$time)})
  sds <- sapply(1:N.m,function(i){sd(grid.dat[[i]]$run.df$time)})
  q <- qnorm(0.975)
  lower.c <- (as.vector(means) - q*as.vector(sds)); upper.c <- (as.vector(means) + q*as.vector(sds))
  meshes.s <- str_extract(meshes, "\\d+\\.*\\d*")
  mesh.lab <- paste0("Mesh ",meshes.s)
  out.time.df <- data.frame(Mesh=mesh.lab,mean=as.vector(means),sd=as.vector(sds),ci.l=lower.c,ci.u=upper.c)
  out.time.df$Mesh <- factor(as.character(out.time.df$Mesh),levels=unique(out.time.df$Mesh)[order(unique(out.time.df$Mesh),decreasing=TRUE)])
  return(out.time.df)
}

param.meansd.mesh <- function(grid.dat){
  N <- nrow(grid.dat[[1]]$est.df)
  meshes <- names(grid.dat); m <- as.factor(meshes); levels(m) <- meshes; N.m <- length(meshes)
  means <- sapply(1:N.m,function(i){colMeans(grid.dat[[i]]$est.df)})
  sds <- sapply(1:N.m,function(i){sapply(grid.dat[[i]]$est.df,sd,2)})
  params <- rownames(means); N.p <- length(params)
  q <- qnorm(0.975)
  lower.c <- (as.vector(means) - q*as.vector(sds)); upper.c <- (as.vector(means) + q*as.vector(sds))
  meshes.s <- str_extract(meshes, "\\d+\\.*\\d*")
  mesh.lab <- paste0("Mesh ",meshes.s)
  out.est.df <- data.frame(Mesh=rep(mesh.lab,each=N.p),Param=rep(params,N.m),mean=as.vector(means),sd=as.vector(sds),ci.l=lower.c,ci.u=upper.c)
  out.est.df$Mesh <- factor(as.character(out.est.df$Mesh),levels=unique(out.est.df$Mesh)[order(unique(out.est.df$Mesh),decreasing=TRUE)])
  out.est.df$Param <- factor(as.character(out.est.df$Param),levels=unique(out.est.df$Param))
  return(out.est.df)
}

combined.meanquantsd.mesh <- function(grid.dat,param){
  # Output Mean, Standard Error, Empirical Quantiles and 95% Intervals 
  N <- length(grid.dat[[1]]$run.df$time)
  grid.dat.sub <- lapply(1:length(run.out.final),function(i){run.out.final[[i]]$est.df[,param]})
  names(grid.dat.sub) <- names(grid.dat)
  meshes <- names(grid.dat); m <- as.factor(meshes); levels(m) <- meshes; N.m <- length(meshes)
  means <- sapply(1:N.m,function(i){colMeans(grid.dat.sub[[i]])})
  means.t <- sapply(1:N.m,function(i){mean(grid.dat[[i]]$run.df$time)})
  means.full <- rbind(means.t,means)
  rownames(means.full)[1] <- "time"
  sel.25 <- sapply(1:N.m,function(i){sapply(1:length(param),function(j,g){sort(g[,j])[25]},grid.dat.sub[[i]])})
  colnames(sel.25) <- names(grid.dat.sub)
  rownames(sel.25) <- param
  sel.25t <- rep(NA,length(N.m))
  sel.25.full <- rbind(sel.25t,sel.25)
  rownames(sel.25.full)[1] <- "time"
  sel.975 <- sapply(1:N.m,function(i){sapply(1:length(param),function(j,g){sort(g[,j])[975]},grid.dat.sub[[i]])})
  colnames(sel.975) <- names(grid.dat.sub)
  rownames(sel.975) <- param
  sel.975t <- rep(NA,length(N.m))
  sel.975.full <- rbind(sel.975t,sel.975)
  sds <- sapply(1:N.m,function(i){sapply(grid.dat.sub[[i]],sd,2)})
  sds.t <- sapply(1:N.m,function(i){sd(grid.dat[[i]]$run.df$time)})
  sds.full <- rbind(sds.t,sds)
  rownames(sds.full)[1] <- "time"
  params <- rownames(means.full); N.p <- length(params)
  q <- qnorm(0.975)
  lower.c <- (as.vector(means.full) - q*as.vector(sds.full)); upper.c <- (as.vector(means.full) + q*as.vector(sds.full))
  meshes.s <- str_extract(meshes, "\\d+\\.*\\d*")
  mesh.lab <- paste0("Mesh ",meshes.s)
  out.df <- data.frame(Mesh=rep(mesh.lab,each=N.p),Param=rep(params,N.m),mean=as.vector(means.full),q0.025=as.vector(sel.25.full),q0.975=as.vector(sel.975.full),sd=as.vector(sds.full),ci.l=lower.c,ci.u=upper.c)
  out.df$Mesh <- factor(as.character(out.df$Mesh),levels=unique(out.df$Mesh)[order(unique(out.df$Mesh),decreasing=TRUE)])
  out.df$Param <- factor(as.character(out.df$Param),levels=unique(out.df$Param))
  return(out.df)
}


# Load Data ---------------------------------------------------------------

# This code for the loading/set-up was taken from GridMeshSGTrad.Rmd
load("../GAUSSIAN_OUTPUT/GridMeshSGTradSS.rda")

N <- 1000; N.grid <- 50; mesh.edge <- round(5/c(10,20,25,50),3)
param <- c("beta0","beta1","beta2","sigma","rho","tau")
meshes <- rep(paste0("Mesh",round(mesh.edge,3)),length(N.grid))
true.theta <- c(1,-2,2,1,1.5,25)
round.vals <- 3
data <- run.out.final



# Create Tables -----------------------------------------------------------

# Code to create table also taken from GridMeshSGTradOutput_final.R
# The only changes made will be to alter the number of significant figures output for the latex table.

l.m <- length(unique(meshes))


full.df <- combined.meanquantsd.mesh(data,param)
full.df.plot <- full.df
meshes.names <- as.character(full.df.plot$Mesh)
ord.meshes.names <- unique(meshes.names)[order(unique(meshes.names),decreasing = T)]
for (i in 1:l.m){
  meshes.names <- str_replace(meshes.names,ord.meshes.names[i],paste0("Mesh ",i)) # assume grid and mesh labels are in order
}
full.df.plot$Mesh <- meshes.names
full.df.plot$Mesh <- factor(as.character(full.df.plot$Mesh),levels=unique(full.df.plot$Mesh)[order(unique(full.df.plot$Mesh),decreasing=FALSE)])


bold <- function(x){
  paste0('{\\bfseries ', x, '}')
}

msd.time <- paste0(signif(full.df$mean[full.df$Param=="time"],digits=round.vals)," (",signif(full.df$ci.l[full.df$Param=="time"],digits=round.vals),",",signif(full.df$ci.u[full.df$Param=="time"],digits=round.vals),")")
msd.param <- paste0(signif(full.df$mean[full.df$Param!="time"],digits=round.vals)," (",signif(full.df$q0.025[full.df$Param!="time"],digits=round.vals),",",signif(full.df$q0.975[full.df$Param!="time"],digits=round.vals),")")
msd <- vector(mode="character",length=(length(msd.time)+length(msd.param)))
msd[full.df$Param=="time"]<- msd.time
msd[full.df$Param!="time"] <- msd.param
rn <- unique(full.df$Param); cn <- unique(full.df$Mesh)
full.matrix <- matrix(msd,length(rn),length(cn),dimnames = list(rn,cn))
full.table <- as.table(full.matrix)

full.table.latex <- xtable(full.matrix)
align(full.table.latex) <- "|c|c|c|c|c|"
digits(full.table.latex) <- 4

param.ind <- str_extract(rownames(full.table.latex), "\\d+\\.*\\d*")
sub.ind <- which(!is.na(str_extract(rownames(full.table.latex), "\\d+\\.*\\d*")))
rownames(full.table.latex)[sub.ind] <- paste0(str_extract(rownames(full.table.latex)[sub.ind],"[a-z]+"),"_",param.ind[sub.ind])
rownames(full.table.latex)[2:nrow(full.table.latex)] <- paste0("$ ","\\",rownames(full.table.latex)[2:nrow(full.table.latex)]," $")

full.table.latex
# % latex table generated in R 4.1.0 by xtable 1.8-4 package
# % Thu Oct 21 12:26:46 2021
# \begin{table}[ht]
# \centering
# \begin{tabular}{|c|c|c|c|c|}
# \hline
# & Mesh 0.5 & Mesh 0.25 & Mesh 0.2 & Mesh 0.1 \\ 
# \hline
# time & 17.9 (14.5,21.3) & 23.3 (19.9,26.7) & 35.2 (28.6,41.8) & 125 (82.9,168) \\ 
# \$ $\backslash$beta\_0 \$ & 1.01 (0.474,1.57) & 1.01 (0.51,1.59) & 1.01 (0.505,1.58) & 1.01 (0.506,1.58) \\ 
# \$ $\backslash$beta\_1 \$ & -2 (-2.02,-1.97) & -2 (-2.02,-1.98) & -2 (-2.02,-1.98) & -2 (-2.02,-1.98) \\ 
# \$ $\backslash$beta\_2 \$ & 2 (1.97,2.03) & 2 (1.98,2.02) & 2 (1.98,2.02) & 2 (1.98,2.02) \\ 
# \$ $\backslash$sigma \$ & 1.04 (0.826,1.29) & 1.06 (0.836,1.33) & 1.07 (0.844,1.33) & 1.04 (0.82,1.3) \\ 
# \$ $\backslash$rho \$ & 1.69 (1.19,2.24) & 1.73 (1.32,2.23) & 1.74 (1.35,2.21) & 1.65 (1.27,2.1) \\ 
# \$ $\backslash$tau \$ & 10.8 (9.81,11.7) & 17.5 (16.3,18.8) & 19.8 (18.4,21.4) & 30.5 (26.8,35.4) \\ 
# \hline
# \end{tabular}
# \end{table}

# Double check there wre no issues due to the behaviour of signif() with 5's
# .Machine$double.eps
# [1] 2.220446e-16
msd.time.eps <- paste0(signif(full.df$mean[full.df$Param=="time"] + .Machine$double.eps,digits=round.vals)," (",signif(full.df$ci.l[full.df$Param=="time"] + .Machine$double.eps,digits=round.vals),",",signif(full.df$ci.u[full.df$Param=="time"] + .Machine$double.eps,digits=round.vals),")")
msd.param.eps <- paste0(signif(full.df$mean[full.df$Param!="time"] + .Machine$double.eps,digits=round.vals)," (",signif(full.df$q0.025[full.df$Param!="time"] + .Machine$double.eps,digits=round.vals),",",signif(full.df$q0.975[full.df$Param!="time"] + .Machine$double.eps,digits=round.vals),")")
msd.eps <- vector(mode="character",length=(length(msd.time.eps)+length(msd.param.eps)))
msd.eps[full.df$Param=="time"]<- msd.time.eps
msd.eps[full.df$Param!="time"] <- msd.param.eps
rn <- unique(full.df$Param); cn <- unique(full.df$Mesh)
full.matrix.eps <- matrix(msd.eps,length(rn),length(cn),dimnames = list(rn,cn))
full.table.eps <- as.table(full.matrix.eps)

full.table.latex.eps <- xtable(full.matrix.eps)
align(full.table.latex.eps) <- "|c|c|c|c|c|"
digits(full.table.latex.eps) <- 4

param.ind.eps <- str_extract(rownames(full.table.latex.eps), "\\d+\\.*\\d*")
sub.ind.eps <- which(!is.na(str_extract(rownames(full.table.latex.eps), "\\d+\\.*\\d*")))
rownames(full.table.latex.eps)[sub.ind.eps] <- paste0(str_extract(rownames(full.table.latex.eps)[sub.ind.eps],"[a-z]+"),"_",param.ind.eps[sub.ind.eps])
rownames(full.table.latex.eps)[2:nrow(full.table.latex.eps)] <- paste0("$ ","\\",rownames(full.table.latex.eps)[2:nrow(full.table.latex.eps)]," $")

full.table.latex.eps
# % latex table generated in R 4.1.0 by xtable 1.8-4 package
# % Thu Oct 21 12:28:20 2021
# \begin{table}[ht]
# \centering
# \begin{tabular}{|c|c|c|c|c|}
# \hline
# & Mesh 0.5 & Mesh 0.25 & Mesh 0.2 & Mesh 0.1 \\ 
# \hline
# time & 17.9 (14.5,21.3) & 23.3 (19.9,26.7) & 35.2 (28.6,41.8) & 125 (82.9,168) \\ 
# \$ $\backslash$beta\_0 \$ & 1.01 (0.474,1.57) & 1.01 (0.51,1.59) & 1.01 (0.505,1.58) & 1.01 (0.506,1.58) \\ 
# \$ $\backslash$beta\_1 \$ & -2 (-2.02,-1.97) & -2 (-2.02,-1.98) & -2 (-2.02,-1.98) & -2 (-2.02,-1.98) \\ 
# \$ $\backslash$beta\_2 \$ & 2 (1.97,2.03) & 2 (1.98,2.02) & 2 (1.98,2.02) & 2 (1.98,2.02) \\ 
# \$ $\backslash$sigma \$ & 1.04 (0.826,1.29) & 1.06 (0.836,1.33) & 1.07 (0.844,1.33) & 1.04 (0.82,1.3) \\ 
# \$ $\backslash$rho \$ & 1.69 (1.19,2.24) & 1.73 (1.32,2.23) & 1.74 (1.35,2.21) & 1.65 (1.27,2.1) \\ 
# \$ $\backslash$tau \$ & 10.8 (9.81,11.7) & 17.5 (16.3,18.8) & 19.8 (18.4,21.4) & 30.5 (26.8,35.4) \\ 
# \hline
# \end{tabular}
# \end{table}



# Session Information -----------------------------------------------------

sessionInfo()
