
# Plotting for Gaussian Example Meshes ------------------------------------

# This R script was used to plot the meshes used for the Gaussian Example for the Grid-Mesh Optimisation method for inclusion in my thesis. These are included in Chapter 2 nd Chapter 3.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

library("rstudioapi")
# Either setwd() to the source file location, or run the following:
setwd(dirname(getActiveDocumentContext()$path))

library(INLA)


# Load Regular Polygon Data -----------------------------------------------

load("MeshesRegPolSG.rda")

# Plotting ----------------------------------------------------------------

# Meshes
pdf("MeshRegPolSG1010.pdf",h=25,w=25,pointsize=14)
plot(mesh.list$mesh0.50.5,main="")
dev.off()
pdf("MeshRegPolSG2020.pdf",h=25,w=25,pointsize=14)
plot(mesh.list$mesh0.250.25,main="")
dev.off()
pdf("MeshRegPolSG2525.pdf",h=25,w=25,pointsize=14)
plot(mesh.list$mesh0.20.2,main="")
dev.off()
pdf("MeshRegPolSG5050.pdf",h=25,w=25,pointsize=14)
plot(mesh.list$mesh0.10.1,main="")
dev.off()


# sessionInfo() -----------------------------------------------------------

sessionInfo()