
# Additional Grid-Mesh Irregular Polygon Plots ----------------------------

# This script produces any extra plots for the results of the grid-mesh procedure on the irregular polygon.
# SBC Mean Field Plots

# Author: Nadeen Khaleel

# Set-Up and Libraries ----------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(purrr)
library(ggplot2)
library(rlist)
library(magrittr)
library(grid)
library(gridExtra)
library(stringr)
library(tidyverse)
library(scales)
library(rlang)

opar <- par()


# Functions ---------------------------------------------------------------

source("SBC_IrregPolLGCP_Latent.R")

# Data --------------------------------------------------------------------

# The below set-up for the SBC parameter output was taken from the .Rmd script that produced the original plots.
load("../IRREGPOLLGCP_OUTPUT/GridMeshIrregPolLGCPSBCSS.rda")

gm <- gm.final

N <- 1000; L <- 100; N.grid <- names(run.out.final); mesh.edge <- names(run.out.final[[1]])
grids <- rep(N.grid,each=length(mesh.edge))
param <- c("beta0","beta1","beta2","sigma","rho")
meshes <- rep(mesh.edge,length(N.grid))

gm.mf <- lapply(gm,function(x){x$ranks.mf})

# SBC Summary Plots -------------------------------------------------------

rank.values <- gm.mf
plot.name=c("irregpolsumdisttest","irregpoloutsideboundstest","irregpolsbcdivergences")

r.n <- length(rank.values)
l.m <- length(unique(meshes))
l.g <- length(unique(grids))

levels.m <- unique(meshes)
levels.g <- unique(grids)

names.gm <- names(rank.values)

grids.names <- grids
ord.grids.names <- unique(grids.names)
for (i in 1:l.g){
  grids.names <- str_replace(grids.names,ord.grids.names[i],paste0("Grid ",i))
}
meshes.names <- meshes
ord.meshes.names <- unique(meshes.names)[order(unique(meshes.names),decreasing = T)]
for (i in 1:l.m){
  meshes.names <- str_replace(meshes.names,ord.meshes.names[i],paste0("Mesh ",i)) # assume grid and mesh labels are in order
}

lower.bound <- qbinom(0.005,N,1/(L+1))
upper.bound <- qbinom(0.995,N,1/(L+1))
m <- N/(L+1)

# As a comparison for the stats, sample from the SAME distribution
mult.same.ranks <- replicate(1e3,run.same(N,L))
freq.multsame.ranks <- apply(mult.same.ranks,2,freq.func)
below.multsame.ranks <- unlist(lapply(1:1e3,FUN=function(i){sum(freq.multsame.ranks[[i]]$freq<lower.bound)}))
above.multsame.ranks <- unlist(lapply(1:1e3,FUN=function(i){sum(freq.multsame.ranks[[i]]$freq>upper.bound)}))
dist.multsame.ranks <- unlist(lapply(1:1e3,FUN=function(i){sum(sqrt((freq.multsame.ranks[[i]]$freq-m)^2))}))
outside.multsame.ranks <- (below.multsame.ranks+above.multsame.ranks)/(L+1) # L + 1 ranks, {0,...,L}

ave.outside.ranks <- mean(outside.multsame.ranks)
ave.dist.ranks <- mean(dist.multsame.ranks)

sd.outside.ranks <- sd(outside.multsame.ranks)
sd.dist.ranks <- sd(dist.multsame.ranks)

f.n <- sapply(1:length(rank.values),function(i){dim(rank.values[[i]])[2]}) # how many ``parameters'' [f(theta) terms are we considering]
if (is.null(f.n)){
  f.n <- length(rank.values[[1]])
}
names.f <- lapply(1:length(rank.values),function(i){names(rank.values[[i]])})


sub.freq.tabs <- function(x,param.names){
  r <- rank.values[[x]]
  out <- lapply(1:f.n[x],function(i){freq.func(r[[i]])})
  names(out) <- paste0("Ranks_",param.names)
  out
}

freq.tabs <- lapply(1:r.n,function(x,param.names){sub.freq.tabs(x,param.names[[x]])},names.f)
names(freq.tabs) <- names.gm


sub.summary <- function(x,param.names){
  f <- freq.tabs[[x]]
  out <- sapply(1:f.n[x],function(i){summary.stats(N,L,f[[i]]$freq,m,lower.bound,upper.bound)})
  colnames(out) <- param.names
  out
}
summaries <- lapply(1:r.n,function(x,param.names){sub.summary(x,param.names[[x]])},names.f)
names(summaries) <- names.gm

OutsideBounds <- unname(unlist(summaries %>% map(~.x[1, ]))) # first row is outside.bounds
MeanDist <- unname(unlist(summaries %>% map(~.x[2, ]))) # second row is dist.sum

sum.df <- data.frame(Grid=rep(grids.names,f.n),Mesh=rep(meshes.names,f.n),Parameter=unlist(names.f),OutsideBounds=OutsideBounds,MeanDist=MeanDist)


sum.df$Grid <- factor(as.character(sum.df$Grid),levels=unique(sum.df$Grid)[order(unique(sum.df$Grid))])
sum.df$Mesh <- factor(as.character(sum.df$Mesh),levels=unique(sum.df$Mesh)[order(unique(sum.df$Mesh),decreasing=FALSE)])

# Setting up labels for the plots
var.lab.orig <- as.character(sum.df$Parameter)
num <- as.numeric(str_extract(var.lab.orig, "[0-9]+"))
char <- str_extract(var.lab.orig, "[aA-zZ]+")

plot.x.lab <- char
plot.x.lab
for (i in which(!is.na(num))){
  plot.x.lab[i] <- paste0(plot.x.lab[i],"[",num[i],"]")
}
plot.x.lab

if (sum(plot.x.lab=="Int")>0){
  plot.x.lab[plot.x.lab=="Int"] <- "beta[0]"
}
sum.df$Label <- plot.x.lab

outside.ylim <- rep(ave.outside.ranks) + c(-1,1)*2*sd.outside.ranks
outside.ylim[1] <- max(0,outside.ylim[1])
dist.ylim <- rep(ave.dist.ranks) + c(-1,1)*2*sd.dist.ranks

p1.1 <- ggplot(sum.df[sum.df$Grid=="Grid 1",],aes(Mesh,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Grid 1") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.2 <- ggplot(sum.df[sum.df$Grid=="Grid 2",],aes(Mesh,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Grid 2") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.3 <- ggplot(sum.df[sum.df$Grid=="Grid 3",],aes(Mesh,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Grid 3") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.4 <- ggplot(sum.df[sum.df$Grid=="Grid 4",],aes(Mesh,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Grid 4") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
ggsave(paste0(plot.name[1],"byGrid1.pdf"),plot=p1.1,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byGrid2.pdf"),plot=p1.2,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byGrid3.pdf"),plot=p1.3,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byGrid4.pdf"),plot=p1.4,width = 15,height = 10,device = "pdf")

p2.1 <- ggplot(sum.df[sum.df$Mesh=="Mesh 1",],aes(Grid,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Mesh 1") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.2 <- ggplot(sum.df[sum.df$Mesh=="Mesh 2",],aes(Grid,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Mesh 2") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.3 <- ggplot(sum.df[sum.df$Mesh=="Mesh 3",],aes(Grid,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Mesh 3") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.4 <- ggplot(sum.df[sum.df$Mesh=="Mesh 4",],aes(Grid,MeanDist)) + scale_y_continuous(limits = c(dist.ylim[1], NA)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=dist.ylim[1],ymax=dist.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.dist.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Sum of Distances of Frequencies from\n Expected Average for Mesh 4") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Summed Distances") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
ggsave(paste0(plot.name[1],"byMesh1.pdf"),plot=p2.1,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byMesh2.pdf"),plot=p2.2,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byMesh3.pdf"),plot=p2.3,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[1],"byMesh4.pdf"),plot=p2.4,width = 15,height = 10,device = "pdf")
# 


# # Second plot the outside of bounds summaries
p1.1 <- ggplot(sum.df[sum.df$Grid=="Grid 1",],aes(Mesh,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Grid 1") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.2 <- ggplot(sum.df[sum.df$Grid=="Grid 2",],aes(Mesh,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Grid 2") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.3 <- ggplot(sum.df[sum.df$Grid=="Grid 3",],aes(Mesh,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Grid 3") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p1.4 <- ggplot(sum.df[sum.df$Grid=="Grid 4",],aes(Mesh,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Mesh))-0.5,xmax=max(as.numeric(sum.df$Mesh))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Mesh)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Grid 4") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
ggsave(paste0(plot.name[2],"byGrid1.pdf"),plot=p1.1,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byGrid2.pdf"),plot=p1.2,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byGrid3.pdf"),plot=p1.3,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byGrid4.pdf"),plot=p1.4,width = 15,height = 10,device = "pdf")

p2.1 <- ggplot(sum.df[sum.df$Mesh=="Mesh 1",],aes(Grid,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Mesh 1") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.2 <- ggplot(sum.df[sum.df$Mesh=="Mesh 2",],aes(Grid,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Mesh 2") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.3 <- ggplot(sum.df[sum.df$Mesh=="Mesh 3",],aes(Grid,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Mesh 3") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
p2.4 <- ggplot(sum.df[sum.df$Mesh=="Mesh 4",],aes(Grid,OutsideBounds)) + geom_rect(data=sum.df,xmin=min(as.numeric(sum.df$Grid))-0.5,xmax=max(as.numeric(sum.df$Grid))+0.5,ymin=outside.ylim[1],ymax=outside.ylim[2],fill="blue",alpha=0.01) + geom_hline(yintercept=rep(ave.outside.ranks,nrow(sum.df)),color="red",linetype="dashed",size=1.5) + geom_boxplot(size=2,aes(color=Grid)) + theme_bw() + ggtitle("Proportion of Frequencies Outside\n Confidence Bounds for Mesh 4") + xlab(expression(paste("f(",~theta,")",sep=""))) + ylab("Proportion") + theme(plot.title = element_text(size=35,hjust=0.5),axis.title = element_text(size=35),axis.text = element_text(size=30),strip.text.x = element_text(size = 20),legend.position = "none")
ggsave(paste0(plot.name[2],"byMesh1.pdf"),plot=p2.1,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byMesh2.pdf"),plot=p2.2,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byMesh3.pdf"),plot=p2.3,width = 15,height = 10,device = "pdf")
ggsave(paste0(plot.name[2],"byMesh4.pdf"),plot=p2.4,width = 15,height = 10,device = "pdf")


# sessionInfo -------------------------------------------------------------

sessionInfo()