
# Parameter Values that Result in Errors ----------------------------------

# Find the value of the parameters for the simulated data that resulted in errors in the SBC simulation study for the LA polygon.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))


# Check Parameter Values --------------------------------------------------


load("../IRREGPOLLGCP_OUTPUT/GridMeshIrregPolLGCPSBCSS.rda")


for (j in 1:4){
  print(paste0("Grid ",j))
  for (l in 1:4){
    print(paste0("Mesh ",l))
    err.tot.jl <- sum(!is.na(run.out.final[[j]][[l]]$mess.ls$error))
    if (err.tot.jl >0){
      data.ind <- which((!is.na(run.out.final[[j]][[l]]$mess.ls$error)))
      print("theta values for errors")
      for (i in 1:length(data.ind)){
        print(true.theta.final[data.ind[i],])
      }
    }
    
  }
}


# [1] "Grid 1"
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0     beta1      beta2     sigma      rho
# 974 4.901376 0.6865738 -0.6760357 0.1688105 8.983632
# [1] "Mesh 2"
# [1] "Mesh 3"
# [1] "theta values for errors"
# beta0    beta1     beta2    sigma      rho
# 141 3.458145 1.142651 0.2180418 1.410539 2.407347
# beta0     beta1         beta2  sigma       rho
# 361 2.770775 0.8604464 -0.0008532766 2.6406 0.7227725
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0     beta1         beta2  sigma       rho
# 361 2.770775 0.8604464 -0.0008532766 2.6406 0.7227725
# beta0     beta1      beta2     sigma      rho
# 974 4.901376 0.6865738 -0.6760357 0.1688105 8.983632
# [1] "Grid 2"
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0    beta1      beta2     sigma      rho
# 251 3.563836 1.641882 -0.1485274 0.5004535 6.412198
# [1] "Mesh 2"
# [1] "Mesh 3"
# [1] "Mesh 4"
# [1] "Grid 3"
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0   beta1     beta2    sigma      rho
# 540 2.622071 2.00689 0.3154203 1.090589 13.25168
# beta0    beta1     beta2      sigma      rho
# 546 3.272435 1.604955 0.1248945 0.02355465 1.562593
# beta0    beta1     beta2    sigma      rho
# 921 3.838233 1.020455 0.9710081 3.227733 2.311674
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0    beta1      beta2     sigma       rho
# 856 2.790247 1.382949 -0.5149555 0.7176612 0.8212983
# [1] "Mesh 3"
# [1] "theta values for errors"
# beta0    beta1      beta2     sigma      rho
# 479 3.32458 1.758606 -0.3961439 0.1210349 1.187017
# beta0     beta1      beta2      sigma       rho
# 738 4.634244 0.4135613 -0.3944152 0.06802721 0.4596939
# [1] "Mesh 4"
# [1] "Grid 4"
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0     beta1     beta2    sigma       rho
# 115 3.132307 0.8972784 0.3238264 1.663679 0.8381427
# beta0    beta1      beta2    sigma      rho
# 196 2.815459 1.914721 -0.3111798 1.416807 6.699561
# beta0    beta1   beta2      sigma      rho
# 434 3.795388 1.290625 0.92024 0.01359262 2.012113
# beta0    beta1     beta2    sigma    rho
# 459 2.710127 1.551266 -0.221407 1.691028 1.3596
# beta0    beta1     beta2    sigma      rho
# 472 4.163235 1.494224 0.3698132 1.876738 2.400657
# beta0    beta1      beta2     sigma      rho
# 816 4.168051 2.015108 -0.5420551 0.7981628 2.578345
# beta0    beta1      beta2   sigma      rho
# 851 3.614131 2.124923 -0.7000833 0.87852 2.484851
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0    beta1       beta2     sigma     rho
# 732 3.670358 1.247426 -0.08147621 0.6172517 22.2272
# [1] "Mesh 3"
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0     beta1     beta2    sigma      rho
# 245 1.918399 0.8569167 0.3503282 2.293095 1.128891
# beta0     beta1     beta2      sigma       rho
# 313 4.455193 0.6850343 -1.249587 0.06740977 0.6484623
# beta0     beta1      beta2      sigma       rho
# 738 4.634244 0.4135613 -0.3944152 0.06802721 0.4596939
# beta0     beta1      beta2     sigma      rho
# 914 3.188174 0.9555199 -0.8612637 0.2858829 18.67972
# beta0    beta1     beta2   sigma    rho
# 948 3.76264 1.546541 0.5342759 1.80562 3.1251


# sessionInfo -------------------------------------------------------------

sessionInfo()
