
# Additional Grid-Mesh Irreg Pol Trad Sim Study Plots: Relabelled ---------

# This script produces any extra plots for the results of the grid-mesh procedure on the irregular polygon.
# Traditional Simulation Study Plots: Relabelled Plots (FFT only)

# Author: Nadeen Khaleel

# Set-Up and Libraries ----------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(purrr)
library(ggplot2)
library(rlist)
library(magrittr)
library(grid)
library(gridExtra)
library(stringr)
library(tidyverse)
library(scales)
library(rlang)

opar <- par()


# Functions ---------------------------------------------------------------

source("./GridMeshIrregPolLGCPTradOutput_Relabel.R")


# Data --------------------------------------------------------------------

load("../../IRREGPOLLGCP_OUTPUT/GridMeshIrregPolLGCPTradSS.rda")

N <- 1000; N.grid <- names(run.out.final); mesh.edge <- names(run.out.final[[1]]) 
grids <- rep(N.grid,each=length(mesh.edge))
param <- c("beta0","beta1","beta2","sigma","rho")
meshes <- rep(mesh.edge,length(N.grid))
true.theta <- c(3,0.75,-0.5,1,2)

# Traditional Simulation Study Error Plots --------------------------------

data <- run.out.final

l.g <- length(unique(grids))
l.m <- length(unique(meshes))
full.df <- lapply(1:length(data),function(i){combined.meanquantsd.mesh(data[[i]],param)})
names(full.df) <- names(data)

full.df.plot <- data.frame(matrix(rep(NA,length(full.df)*nrow(full.df[[1]])*(1+ncol(full.df[[1]]))),nrow=length(full.df)*nrow(full.df[[1]])))
colnames(full.df.plot) <- c("Grid",colnames(full.df[[1]]))
full.df.plot$Grid <- rep(names(full.df),each=nrow(full.df[[1]]))
for (i in 1:4){
  df.ind <- (i-1)*nrow(full.df[[i]])
  full.df[[i]]$Param <- as.character(full.df[[i]]$Param)
  full.df[[i]]$Mesh <- as.character(full.df[[i]]$Mesh)
  full.df.plot[((df.ind+1):(df.ind+nrow(full.df[[i]]))),2:ncol(full.df.plot)] <- full.df[[i]]
}

grids.names <- grids
ord.grids.names <- unique(grids.names)
for (i in 1:l.g){
  grids.names <- str_replace(grids.names,ord.grids.names[i],paste0("Grid ",i))
}
meshes.names <- meshes
ord.meshes.names <- unique(meshes.names)[order(unique(meshes.names),decreasing = T)]
for (i in 1:l.m){
  meshes.names <- str_replace(meshes.names,ord.meshes.names[i],paste0("Mesh ",i)) # assume grid and mesh labels are in order
}

err.df <- data.frame(Grid=rep(unique(grids.names),each=12*N),Mesh=rep(rep(unique(meshes.names),each=3*N),4),Criterion=rep(rep(c("Error","Warning","FFT"),each=N),16),Run=rep(1:N,(4*4*3)))
start.ind <- 1
for (i in 1:length(run.out.final)){
  for (j in 1:length(run.out.final[[i]])){
    err <- run.out.final[[i]][[j]]$mess.ls$error
    err[!is.na(err)] <- 1
    err[is.na(err)] <- 0
    warn <- run.out.final[[i]][[j]]$mess.ls$warning
    warn[!is.na(warn)] <- 1
    warn[is.na(warn)] <- 0
    fft <- run.out.final[[i]][[j]]$mess.ls$FFT
    err.df$Value[start.ind:(start.ind+length(err)-1)] <- err
    start.ind <- start.ind + length(err)
    err.df$Value[start.ind:(start.ind+length(warn)-1)] <- warn
    start.ind <- start.ind + length(warn)
    err.df$Value[start.ind:(start.ind+length(fft)-1)] <- fft
    start.ind <- start.ind + length(fft)
  }
}
err.df$Grid <- as.factor(err.df$Grid)
err.df$Mesh <- factor(as.character(err.df$Mesh),levels=unique(err.df$Mesh)[order(unique(err.df$Mesh),decreasing=FALSE)])
err.df$Criterion <- as.factor(err.df$Criterion)
err.df$Value <- as.numeric(err.df$Value)

errsum.df <- err.df
errsum.df %<>%
  group_by(Grid,Mesh,Criterion) %>%
  summarise(mean = mean(Value),sd=sd(Value), n = n())



p1 <- ggplot(errsum.df[errsum.df$Criterion=="FFT",]) + geom_point(aes(x=Mesh,y=mean,col=Mesh,size=2)) + scale_x_discrete(limits = levels(full.df.plot$Mesh)) + xlab("Mesh") + facet_wrap(~Grid,scales="free_x",ncol=2) + theme(plot.title = element_text(size=35,hjust = 0.5),axis.title = element_text(size=25),axis.text = element_text(size=15),strip.text.x = element_text(size=20),legend.position = "none")
p2 <- ggplot(errsum.df[errsum.df$Criterion=="FFT",]) + geom_point(aes(x=Grid,y=mean,col=Grid,size=2)) + scale_x_discrete(limits = levels(full.df.plot$Grid)) + xlab("Grid") + facet_wrap(~Mesh,scales="free_x",ncol=2) + theme(plot.title = element_text(size=35,hjust = 0.5),axis.title = element_text(size=25),axis.text = element_text(size=15),strip.text.x = element_text(size=20),legend.position = "none")

ggsave("IrregPolLGCPTradErrFFTOnlyMeanbyGrid_Relabel.pdf",plot=p1,width = 15,height = 10,device="pdf")
ggsave("IrregPolLGCPTradErrFFTOnlyMeanbyMesh_Relabel.pdf",plot=p2,width = 15,height = 10,device="pdf")


# sessionInfo -------------------------------------------------------------

sessionInfo()