
# Checking Time/Space Error Re-Runs LA Polygon ----------------------------

# This R script produces text file outputs that allows us to compare the pre- and post-time and /or space error re-runs to ensure there are no differences other than an error that is now a warning (if it has been re-run with and output) or even still an error if it could not be re-run.

# Author: Nadeen Khaleel

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))



# Check Re-Runs -----------------------------------------------------------

# Select the process we are interested in.
procs <- c(2,5,6,7,8,9,10,11,14,16,17,18,19,20,23,27,29,30,32,33,35,38,40)

sink("DoubleCheckingTimingErrorReRun.txt")
print(Sys.time())
print("Want to double check that the outputs after the timing error rerun, are the same. Especially for P2 and P7, P7 did NOT run but the new data set was created and save. P2 should be the same with the Time Error rerun, but P7 should be the exact same as time error was not the same.")
for (ii in 1:length(procs)){

  k.ind <- ii
  k <- procs[k.ind]
  this.node <- k%/%2 + as.numeric(k%%2!=0)

  print(paste0("Process ",k))
  if(k %in%c(11,40)){
    old.file <- paste0("../GridMeshIrregPolLGCPSBCSS",k,"_SPACEERRORFINAL.rda")
  } else {
    old.file <- paste0("../GridMeshIrregPolLGCPSBCSS",k,"_TIMEERRORFINAL.rda")  
  }
  print(old.file)
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)

  save.file <- paste0("../GridMeshIrregPolLGCPSBCSS",k,".rda")
  load(save.file)

  N.g <- 4; N.m <- 4

  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss

  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }


  print("Names gm")
  print(names(gm.old))
  print(names(gm))

  print(sum(names(gm.old)==names(gm)))
  print(sum(names(gm.old)!=names(gm)))


  for (i in 1:4){
    for (j in 1:4){
      print("Length Message")
      lm <- length(run.out[[i]][[j]]$mess.ls$message)
      print(lm)
      print("Null Messages Counts")
      print(sum(sapply(1:lm,function(l){is.null(run.out.old[[i]][[j]]$mess.ls$message[[l]])})))
      print(sum(sapply(1:lm,function(l){is.null(run.out[[i]][[j]]$mess.ls$message[[l]])})))
    }
  }
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length FFT")
      lm <- length(run.out[[i]][[j]]$mess.ls$FFT)
      print(lm)
      print("Length Error")
      lm2 <- length(run.out[[i]][[j]]$mess.ls$error)
      print(lm2)
      print("FFT Count")
      print(sum((run.out.old[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print(sum((run.out[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print("Warnings Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$warning)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$warning)))
      print("Errors Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$error)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$error)))
    }
  }
  
  #######

  # CHECKS ####

  if (grid.start.ind==1&mesh.start.ind==1){ # for time error addition
    p.check <- p.length - 1
  } else {
    p.check <- p.length
  }
  
  print("Compare true.theta and seed.vec")
  print(sum(true.theta[1:p.check,]-true.theta.old[1:p.check,]))
  print(max(abs(true.theta[1:p.check,]-true.theta.old[1:p.check,])))
  print(sum(seed.vec[1:p.check]-seed.vec.old[1:p.check]))
  print(max(abs(seed.vec[1:p.check]-seed.vec.old[1:p.check])))

  print("data.err.tracker comparison")
  print(data.err.tracker)
  print(data.err.tracker.old)

  print("Sum and Max-Abs Different and sum is.na in est.df")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(is.na(run.out[[jj]][[ll]]$est.df)))

      print(sum(!is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(!is.na(run.out[[jj]][[ll]]$est.df)))
    }
  }

  print("Sum and Max-Abs difference in FFT")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))

      print(sum(!is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(!is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
    }
  }

  N.g <- 4; N.m <- 4

  print("Sum and Max-Abs difference in ranks.param")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,])))

      print(sum(is.na(gm.old[[ind]]$ranks.param)))
      print(sum(is.na(gm[[ind]]$ranks.param)))

      print(sum(!is.na(gm.old[[ind]]$ranks.param)))
      print(sum(!is.na(gm[[ind]]$ranks.param)))
    }
  }

  print("Sum and Max-Abs difference in ranks.mf")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,])))

      print(sum(is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(is.na(gm[[ind]]$ranks.mf)))

      print(sum(!is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(!is.na(gm[[ind]]$ranks.mf)))
    }
  }

  for (i in 1:16){
    print(paste0("Dimension gm.old ", i))
    print(dim(gm.old[[i]]$ranks.param))
    print(dim(gm.old[[i]]$ranks.mf))
    print(paste0("Dimension gm ", i))
    print(dim(gm[[i]]$ranks.param))
    print(dim(gm[[i]]$ranks.mf))
  }



}

sink()

rm(list=ls())


# sessionInfo -------------------------------------------------------------

sessionInfo()
